/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.model.util;

import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.model.util.CurrencyFormat;
import java.io.Serializable;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class LocalizationDetail
implements Serializable {
    private static final long serialVersionUID = 8952994864635465845L;
    private static final String UNDERLINE = "_";
    private Locale location = Locale.getDefault();
    private Locale language = Locale.getDefault();
    private TimeZone timeZone = TimeZone.getDefault();
    private CurrencyFormat currencyFormat = new CurrencyFormat();

    public LocalizationDetail() {
    }

    public LocalizationDetail(String location, String language, String timeZone) {
        if (StringUtils.isNotEmpty((CharSequence)location)) {
            this.location = this.createLocale(location);
        }
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            this.language = this.createLocale(location);
        }
        if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
            this.timeZone = TimeZone.getTimeZone(timeZone);
        }
    }

    public LocalizationDetail(Locale location, Locale language, TimeZone timeZone, CurrencyFormat currencyFormat) {
        this.location = location;
        this.language = language;
        this.timeZone = timeZone;
        this.currencyFormat = currencyFormat;
    }

    public Locale getLocation() {
        return this.location;
    }

    public void setLocation(Locale location) {
        this.location = location;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public CurrencyFormat getCurrencyFormat() {
        return this.currencyFormat;
    }

    public void setCurrencyFormat(CurrencyFormat currencyFormat) {
        this.currencyFormat = currencyFormat;
    }

    private Locale createLocale(String location) {
        if (location.contains(UNDERLINE)) {
            return new Locale(StringUtils.substringBefore((String)location, (String)UNDERLINE), StringUtils.substringAfter((String)location, (String)UNDERLINE));
        }
        return new Locale(location);
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

