/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.model.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EncryptTypeHandler
extends BaseTypeHandler<String> {
    private static EncryptorAdapter encryptorAdapter;

    @Autowired(required=false)
    public void setEncryptorAdapter(EncryptorAdapter encryptorAdapter) {
        EncryptTypeHandler.encryptorAdapter = encryptorAdapter;
    }

    private static String encrypt(String message) {
        return Objects.nonNull(encryptorAdapter) ? encryptorAdapter.encrypt(message) : message;
    }

    private static String decrypt(String encryptedMessage) {
        return Objects.nonNull(encryptorAdapter) ? encryptorAdapter.decrypt(encryptedMessage) : encryptedMessage;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        if (StringUtils.isBlank((CharSequence)parameter)) {
            ps.setString(i, parameter);
            return;
        }
        ps.setString(i, EncryptTypeHandler.encrypt(parameter));
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = EncryptTypeHandler.decrypt(value);
        }
        return value;
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = EncryptTypeHandler.decrypt(value);
        }
        return value;
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = EncryptTypeHandler.decrypt(value);
        }
        return value;
    }

    public static interface EncryptorAdapter {
        public String encrypt(String var1);

        public String decrypt(String var1);
    }
}

