/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.model.handler;

import com.alibaba.fastjson.JSON;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class StringListJsonTypeHandler
extends BaseTypeHandler<List<String>> {
    public void setNonNullParameter(PreparedStatement ps, int i, List<String> parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setString(i, "");
            return;
        }
        ps.setString(i, JSON.toJSONString(parameter));
    }

    public List<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getStringList(rs.getString(columnName));
    }

    public List<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getStringList(rs.getString(columnIndex));
    }

    public List<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getStringList(cs.getString(columnIndex));
    }

    private List<String> getStringList(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ArrayList<String>();
        }
        return JSON.parseArray((String)str).stream().map(o -> {
            if (o == null) {
                return null;
            }
            return o.toString();
        }).collect(Collectors.toList());
    }
}

