/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.exporter;

import com.cyberway.msf.commons.core.exception.BaseException;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.Resource;

public class ExportEntity {
    private Resource template;
    private int headerRowNum = 1;
    private String sheetName;
    private String[] headerRowNames;
    private List<Object[]> datas = new ArrayList<Object[]>();
    private CellStyle headerCellStyle;
    private CellStyle cellStyle;
    private int defalutColumnWidth = 18;
    private String exportName;
    private Workbook workbook;

    public ExportEntity(String sheetName, String[] headerRowNames, List<Object[]> datas) {
        this(sheetName, null, headerRowNames, datas);
    }

    public ExportEntity(String sheetName, String exportName, String[] headerRowNames, List<Object[]> datas) {
        if (headerRowNames == null || headerRowNames.length <= 0) {
            throw new IllegalArgumentException(String.valueOf("Header row names can not be empty"));
        }
        this.sheetName = sheetName;
        this.exportName = exportName;
        this.headerRowNames = (String[])headerRowNames.clone();
        this.datas = datas;
        this.initWorkbook();
    }

    public ExportEntity(Resource template, List<Object[]> datas) {
        if (template == null || !template.exists()) {
            throw new IllegalArgumentException(String.valueOf("Template not exists"));
        }
        this.template = template;
        this.datas = datas;
        this.initWorkbook();
    }

    protected void initWorkbook() {
        InputStream is;
        block5: {
            is = null;
            try {
                if (this.getTemplate() != null) {
                    String ext = StringUtils.substringAfterLast((String)this.getTemplate().getFilename(), (String)".");
                    is = this.getTemplate().getInputStream();
                    this.workbook = "xls".equalsIgnoreCase(ext) ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
                    break block5;
                }
                String ext = StringUtils.substringAfterLast((String)this.getExportName(), (String)".");
                this.workbook = "xls".equalsIgnoreCase(ext) ? new HSSFWorkbook() : new XSSFWorkbook();
                this.setHeaderCellStyle(this.createDefaultHeaderStyle(this.workbook));
                this.setCellStyle(this.createDefaultCellStyle(this.workbook));
            }
            catch (Exception e) {
                try {
                    throw new BaseException("EXPORT_EXCEL_FAIL");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Closeable)is);
    }

    public void handleHeaderRows(Sheet sheet) {
        if (this.getHeaderRowNames() != null) {
            Row row = sheet.createRow(this.getHeaderRowNum() - 1);
            for (int i = 0; i < this.getHeaderRowNames().length; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellValue(this.getHeaderRowNames()[i]);
                if (this.getHeaderCellStyle() != null) {
                    cell.setCellStyle(this.getHeaderCellStyle());
                }
                if (this.getDefalutColumnWidth() <= 0) continue;
                sheet.setColumnWidth(i, this.getDefalutColumnWidth() * 256);
            }
        }
    }

    public CellStyle createDefaultHeaderStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        font.setFontName("Courier New");
        CellStyle style = workbook.createCellStyle();
        style.setFont(font);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        return style;
    }

    public CellStyle createDefaultCellStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("Courier New");
        CellStyle style = workbook.createCellStyle();
        style.setFont(font);
        style.setWrapText(false);
        return style;
    }

    public Workbook export() throws BaseException {
        Sheet sheet = null;
        if (this.getTemplate() != null) {
            sheet = this.workbook.getSheetAt(0);
        } else {
            sheet = StringUtils.isNotEmpty((CharSequence)this.getSheetName()) ? this.workbook.createSheet(this.getSheetName()) : this.workbook.createSheet();
            this.handleHeaderRows(sheet);
        }
        int rownum = this.getHeaderRowNum();
        DataFormat dataFormat = this.workbook.createDataFormat();
        CellStyle dateCellStyle = this.workbook.createCellStyle();
        CellStyle defaultCellStyle = this.workbook.createCellStyle();
        if (this.getCellStyle() != null) {
            defaultCellStyle.cloneStyleFrom(this.getCellStyle());
            dateCellStyle.cloneStyleFrom(this.getCellStyle());
        }
        dateCellStyle.setDataFormat(dataFormat.getFormat("yyyy/mm/dd"));
        this.setCellValue(sheet, rownum, dateCellStyle, defaultCellStyle);
        return this.workbook;
    }

    private void setCellValue(Sheet sheet, int rownum, CellStyle dateCellStyle, CellStyle defaultCellStyle) {
        for (Object[] rowData : this.getDatas()) {
            Row row = sheet.createRow(rownum++);
            int column = 0;
            for (Object cellData : rowData) {
                Cell cell = row.createCell(column++);
                CellStyle style = defaultCellStyle;
                if (cellData == null) {
                    cell.setCellValue("");
                } else if (cellData instanceof Number) {
                    cell.setCellValue(((Number)cellData).doubleValue());
                } else if (cellData instanceof Boolean) {
                    cell.setCellValue(((Boolean)cellData).booleanValue());
                } else if (cellData instanceof Date) {
                    cell.setCellValue((Date)cellData);
                    style = dateCellStyle;
                } else {
                    cell.setCellValue(Objects.toString(cellData));
                }
                if (style == null) continue;
                cell.setCellStyle(style);
            }
        }
    }

    public Resource getTemplate() {
        return this.template;
    }

    public void setTemplate(Resource template) {
        this.template = template;
    }

    public int getHeaderRowNum() {
        return this.headerRowNum;
    }

    public void setHeaderRowNum(int headerRowNum) {
        this.headerRowNum = headerRowNum;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String[] getHeaderRowNames() {
        return this.headerRowNames == null ? null : (String[])this.headerRowNames.clone();
    }

    public void setHeaderRowNames(String[] headerRowNames) {
        this.headerRowNames = headerRowNames == null ? null : (String[])headerRowNames.clone();
    }

    public List<Object[]> getDatas() {
        return this.datas;
    }

    public void setDatas(List<Object[]> datas) {
        this.datas = datas;
    }

    public CellStyle getHeaderCellStyle() {
        return this.headerCellStyle;
    }

    public void setHeaderCellStyle(CellStyle headerCellStyle) {
        this.headerCellStyle = headerCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public int getDefalutColumnWidth() {
        return this.defalutColumnWidth;
    }

    public void setDefalutColumnWidth(int defalutColumnWidth) {
        this.defalutColumnWidth = defalutColumnWidth;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }
}

