/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.importer;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ImportExcelUtils {
    private final Logger logger = LoggerFactory.getLogger(ImportExcelUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> uploadExcle(MultipartFile file, Integer line) {
        String ext;
        this.logger.info("handle Excle starts...");
        List<List<String>> excleData = new ArrayList<List<String>>();
        if (file == null) {
            this.logger.error("file is not found!");
            return excleData;
        }
        String filename = file.getOriginalFilename();
        if (filename == null || "".equals(filename)) {
            this.logger.error("file is not found!");
            return excleData;
        }
        int iIndex = filename.lastIndexOf(46);
        String string = ext = iIndex < 0 ? "" : filename.substring(iIndex + 1).toLowerCase();
        if (!"xlsx".equals(ext) && !"xls".equals(ext)) {
            this.logger.error(filename + "not a Microsoft EXCEL file");
        }
        InputStream input = null;
        try {
            input = file.getInputStream();
            if ("xlsx".equals(ext)) {
                XSSFWorkbook workBook = new XSSFWorkbook(input);
                XSSFSheet sheet = (XSSFSheet)workBook.getSheetAt(0);
                excleData = this.getCellVal((Sheet)sheet, line);
            } else if ("xls".equals(ext)) {
                HSSFWorkbook workBook = new HSSFWorkbook(input);
                HSSFSheet sheet = (HSSFSheet)workBook.getSheetAt(0);
                excleData = this.getCellVal((Sheet)sheet, line);
            }
        }
        catch (IOException e) {
            this.logger.error("export excel error :{}", (Throwable)e);
        }
        finally {
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (IOException e) {
                this.logger.error("close IO fail");
            }
        }
        return excleData;
    }

    private List<List<String>> getCellVal(Sheet sheet, Integer line) {
        ArrayList<List<String>> excleData = new ArrayList<List<String>>();
        for (int i = line - 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
            Row row = sheet.getRow(i);
            if (null == row) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < sheet.getRow(0).getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                String cellValue = this.getCellValue(cell);
                list.add(cellValue);
            }
            if (CollectionUtils.isEmpty(list)) continue;
            excleData.add(list);
        }
        return excleData;
    }

    private String getCellValue(Cell cell) {
        String cellValue = "";
        if (null != cell) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date theDate = cell.getDateCellValue();
                        SimpleDateFormat dff = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = dff.format(theDate);
                        break;
                    }
                    DecimalFormat df = new DecimalFormat("0");
                    cellValue = df.format(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    cellValue = cell.getBooleanCellValue() + "";
                    break;
                }
                case FORMULA: {
                    cellValue = cell.getCellFormula() + "";
                    break;
                }
                case BLANK: {
                    break;
                }
                case ERROR: {
                    cellValue = "\u975e\u6cd5\u5b57\u7b26";
                    break;
                }
                default: {
                    cellValue = "\u672a\u77e5\u7c7b\u578b";
                }
            }
        }
        return cellValue;
    }
}

