/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.importer;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.cyberway.msf.commons.api.result.ApiResultCode;
import com.cyberway.msf.commons.base.util.MessageUtils;
import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.commons.poi.importer.AsyncImportExcelHandler;
import com.cyberway.msf.commons.poi.importer.DefaultDataListener;
import com.cyberway.msf.commons.poi.importer.ExtendImportResult;
import com.cyberway.msf.commons.poi.model.ImportApiResultCode;
import com.cyberway.msf.commons.poi.model.WrapRow;
import com.cyberway.msf.commons.poi.util.Constants;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.StringUtils;

public abstract class AbstractAsyncImportExcelRowHandler
implements AsyncImportExcelHandler,
InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private I18nUtils i18nUtils;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    @Qualifier(value="importThreadPoolExecutor")
    private ThreadPoolExecutor threadPoolExecutor;

    protected I18nUtils getI18nUtils() {
        return this.i18nUtils;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.redisUtils) {
            throw new UnsupportedOperationException("redisUtils is null!");
        }
        if (null == this.threadPoolExecutor) {
            throw new UnsupportedOperationException("threadPoolExecutor  is null!");
        }
    }

    @Override
    public void asyncHandleExcel(InputStream is) {
        String lockKey = this.getImportLockKey();
        boolean lockSuccess = this.redisUtils.lockOrigin(lockKey, (long)this.getImportLockTimeoutSeconds().intValue());
        if (!lockSuccess) {
            this.logger.warn("import lock fail!lockKey is:{}", (Object)lockKey);
            throw MessageUtils.buildException((ApiResultCode)ImportApiResultCode.IMPORT_TASK_EXIST, (Object[])new Object[0]);
        }
        UserInfo currentUser = UserUtils.getLoggedInUser();
        this.threadPoolExecutor.execute(() -> {
            UserUtils.setLocalUserInfo((UserInfo)currentUser, (boolean)true);
            ExtendImportResult importResult = new ExtendImportResult();
            importResult.setUid(UUID.randomUUID().toString());
            try {
                this.beforeImportExcel();
                ((ExcelReaderSheetBuilder)EasyExcelFactory.read((InputStream)is, (ReadListener)new DefaultDataListener(this, importResult)).sheet().headRowNumber(Integer.valueOf(this.getHeaderRowNum()))).doRead();
            }
            catch (Exception e) {
                importResult.setFailMsg(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
                importResult.setSuccess(false);
                importResult.setFinishFlag(true);
                this.logger.error("\u5904\u7406excel\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.redisUtils.unlockOrigin(lockKey);
                this.flushResultCache(importResult);
                UserUtils.resetLocalUserInfo();
            }
        });
    }

    protected void beforeImportExcel() {
    }

    public String handleRowException(WrapRow row) {
        String handleResult;
        try {
            handleResult = this.handleRow(row);
        }
        catch (BaseException e) {
            handleResult = e.getMessage();
            this.logger.error(handleResult, (Throwable)e);
        }
        catch (Exception e) {
            handleResult = this.getI18nUtils().getMessage("unknownError");
            this.logger.error(handleResult, (Throwable)e);
        }
        return handleResult;
    }

    protected String getImportLockKey() {
        return "lock:import:" + this.getTaskFlag();
    }

    public List<ExtendImportResult> getResultCache() {
        String redisKey = this.getCacheKey();
        String jsonList = (String)this.redisUtils.getOrigin(redisKey);
        List resultList = StringUtils.isEmpty((Object)jsonList) ? new ArrayList() : JSON.parseArray((String)jsonList, ExtendImportResult.class);
        return resultList;
    }

    private String getCacheKey() {
        UserInfo userInfo = UserUtils.getLoggedInUser();
        if (null == userInfo) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230\u5f53\u524d\u64cd\u4f5c\u4eba");
        }
        return String.format("ImportResult:%s:%s", userInfo == null ? Integer.valueOf(-1) : userInfo.getId(), this.getTaskFlag());
    }

    protected void flushResultCache(ExtendImportResult importResult) {
        importResult.setUsedTime(System.currentTimeMillis() - importResult.getInvokeTime().getTime());
        List<ExtendImportResult> resultList = this.getResultCache();
        Map<String, ExtendImportResult> resultMap = resultList.stream().collect(Collectors.toMap(ExtendImportResult::getUid, i -> i, (i1, i2) -> i1));
        if (resultMap.containsKey(importResult.getUid())) {
            BeanUtils.copyProperties((Object)importResult, (Object)resultMap.get(importResult.getUid()));
        } else {
            resultList.add(0, importResult);
        }
        if (resultList.size() > 5) {
            resultList = resultList.subList(0, 5);
        }
        this.redisUtils.setOrigin(this.getCacheKey(), (Object)JSON.toJSONString(resultList), 3600L);
    }

    private String getTaskFlag() {
        String[] str = this.getClass().getName().split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            if (i != str.length - 1) {
                sb.append(str[i].charAt(0)).append(".");
                continue;
            }
            sb.append(str[i]);
        }
        return sb.toString();
    }

    protected Integer getImportLockTimeoutSeconds() {
        return Constants.IMPORT_LOCK_TIMEOUT_SECONDS;
    }

    protected abstract String handleRow(WrapRow var1);

    protected void afterBatch(ExtendImportResult result) {
        this.doAfterBatch(result);
        this.flushResultCache(result);
    }

    protected void doAfterBatch(ExtendImportResult importResult) {
    }

    public void afterHandleSheet(ExtendImportResult importResult) {
        this.doAfterBatch(importResult);
        this.doAfterHandleSheet(importResult);
        if (importResult.getSuccessRowCount() > 0) {
            importResult.setSuccess(true);
        } else {
            importResult.setSuccess(false);
            importResult.setFailMsg(this.getI18nUtils().getMessage("allFail"));
        }
        importResult.setFinishFlag(true);
    }

    protected abstract void doAfterHandleSheet(ExtendImportResult var1);

    protected int getHeaderRowNum() {
        return Constants.DEFAULT_HEAD_ROW_NUMS;
    }

    protected String checkHeaderRows(List<WrapRow> rows) {
        return null;
    }

    protected boolean handleHeaderRows() {
        return false;
    }

    protected boolean handleRowException() {
        return true;
    }

    protected boolean skipOnRowFail() {
        return true;
    }

    protected int getMaxHandleRowNum() {
        return Constants.DEFAULT_MAX_HANDLE_ROW_NUMS;
    }

    protected int getBatchSize() {
        return Constants.DEFAULT_BATCH_SIZE;
    }
}

