/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.model;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WrapRow {
    private final Map<Integer, ReadCellData> cellDataMap;
    private final AnalysisContext analysisContext;

    public WrapRow(Map<Integer, ReadCellData> cellDataMap, AnalysisContext analysisContext) {
        this.cellDataMap = cellDataMap;
        this.analysisContext = analysisContext;
    }

    public String readString(int position) {
        return this.readData(position, String.class);
    }

    public Integer readInt(int position) {
        return this.readData(position, Integer.class);
    }

    public Long readLong(int position) {
        return this.readData(position, Long.class);
    }

    public BigDecimal readBigDecimal(int position) {
        return this.readData(position, BigDecimal.class);
    }

    public BigInteger readBigInteger(int position) {
        return this.readData(position, BigInteger.class);
    }

    public Date readDate(int position) {
        return this.readData(position, Date.class);
    }

    public Boolean readBoolean(int position) {
        return this.readData(position, Boolean.class);
    }

    public Short readShort(int position) {
        return this.readData(position, Short.class);
    }

    public Double readDouble(int position) {
        return this.readData(position, Double.class);
    }

    public Float readFloat(int position) {
        return this.readData(position, Float.class);
    }

    public <T> T readData(int position, Class<T> clazz) {
        return this.readData(position, null, clazz);
    }

    public <T> T readData(int position, ExcelContentProperty contentProperty, Class<T> clazz) {
        ReadCellData cellData = this.cellDataMap.get(position);
        if (null == cellData) {
            return null;
        }
        Converter converter = (Converter)this.analysisContext.readSheetHolder().converterMap().get(ConverterKeyBuild.buildKey(clazz, (CellDataTypeEnum)cellData.getType()));
        if (null != converter) {
            try {
                return (T)converter.convertToJavaData(new ReadConverterContext(cellData, contentProperty, this.analysisContext));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Map<Integer, ReadCellData> getCellDataMap() {
        return this.cellDataMap;
    }

    public boolean isEmptyRow() {
        if (null == this.cellDataMap || CollectionUtils.isEmpty(this.cellDataMap)) {
            return true;
        }
        ReadCellData data = this.cellDataMap.values().stream().filter(value -> null != value && value.getType() != CellDataTypeEnum.EMPTY && !StringUtils.isEmpty((Object)value.getStringValue())).findFirst().orElse(null);
        return data == null;
    }
}

