/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.importer;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.poi.importer.AbstractAsyncImportExcelRowHandler;
import com.cyberway.msf.commons.poi.importer.ExtendImportResult;
import com.cyberway.msf.commons.poi.model.WrapRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class DefaultDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    private final AbstractAsyncImportExcelRowHandler handler;
    private final ExtendImportResult importResult;
    private final List<WrapRow> headRows = new ArrayList<WrapRow>();
    private Integer processCount = 0;

    public DefaultDataListener(AbstractAsyncImportExcelRowHandler handler, ExtendImportResult importResult) {
        this.handler = handler;
        this.importResult = importResult;
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        WrapRow wrapRow = this.buildWrapRow(context);
        this.headRows.add(wrapRow);
        if (this.headRows.size() == this.handler.getHeaderRowNum()) {
            String errorMsg = this.handler.checkHeaderRows(this.headRows);
            this.headRows.clear();
            if (!StringUtils.isEmpty((Object)errorMsg)) {
                throw new BaseException("\u5934\u90e8\u6821\u9a8c\u5931\u8d25:" + errorMsg);
            }
        }
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        Integer n = this.processCount;
        Integer n2 = this.processCount = Integer.valueOf(this.processCount + 1);
        if (this.processCount > this.handler.getMaxHandleRowNum()) {
            return;
        }
        WrapRow wrapRow = this.buildWrapRow(context);
        if (!wrapRow.isEmptyRow()) {
            String errorMsg = !this.handler.handleHeaderRows() ? this.handler.handleRow(wrapRow) : this.handler.handleRowException(wrapRow);
            if (!StringUtils.isEmpty((Object)errorMsg)) {
                this.importResult.getFailRowNums().add(this.processCount);
                this.importResult.getFailRowMsgs().add(errorMsg);
                this.importResult.setFailRowCount(this.importResult.getFailRowCount() + 1);
                if (!this.handler.skipOnRowFail()) {
                    throw new BaseException("\u672a\u8df3\u8fc7\u9519\u8bef\u7684\u884c:" + errorMsg);
                }
            } else {
                this.importResult.setSuccessRowCount(this.importResult.getSuccessRowCount() + 1);
            }
        }
        if (this.processCount % this.handler.getBatchSize() == 0) {
            this.handler.afterBatch(this.importResult);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.handler.afterHandleSheet(this.importResult);
    }

    private WrapRow buildWrapRow(AnalysisContext context) {
        Map map = context.readSheetHolder().getCellMap();
        HashMap<Integer, ReadCellData> wrapMap = new HashMap<Integer, ReadCellData>(map.size());
        map.forEach((position, cell) -> wrapMap.put((Integer)position, (ReadCellData)cell));
        return new WrapRow(wrapMap, context);
    }
}

