/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.exporter;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.cyberway.msf.commons.core.exception.BaseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public class EasyExcelExport {
    private Resource template;
    private int headerRowNum = 1;
    private String sheetName;
    private String[] headerRowNames;
    private List<List<Object>> data;
    private int defaultColumnWidth = 18;
    private String exportName = "export.xlsx";

    public void exportWeb(HttpServletResponse response) throws BaseException {
        this.appendExportWeb(response).appendList(this.data).finish();
    }

    public ExcelDataAppender appendExportWeb(HttpServletResponse response) throws BaseException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(this.getExportName(), "UTF-8").replace("\\+", "%20");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            return this.appendExport((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new BaseException("export excel error!", (Throwable)e);
        }
    }

    public ExcelDataAppender appendExport(OutputStream os) throws BaseException {
        WriteSheet writeSheet;
        String ext;
        ExcelWriterBuilder writerBuilder = EasyExcel.write((OutputStream)os);
        if (this.getTemplate() != null) {
            ext = StringUtils.substringAfterLast((String)this.getTemplate().getFilename(), (String)".");
            try {
                InputStream is = this.getTemplate().getInputStream();
                writerBuilder.withTemplate(is);
                writeSheet = EasyExcel.writerSheet((Integer)0).build();
            }
            catch (IOException e) {
                throw new BaseException("get export template error!", (Throwable)e);
            }
        } else {
            ext = StringUtils.substringAfterLast((String)this.getExportName(), (String)".");
            writeSheet = StringUtils.isNotEmpty((CharSequence)this.getSheetName()) ? EasyExcel.writerSheet((String)this.getSheetName()).build() : EasyExcel.writerSheet((Integer)0).build();
            if (this.getHeaderRowNames() != null && this.getHeaderRowNames().length > 0) {
                ArrayList<List<String>> headList = new ArrayList<List<String>>();
                for (String headerRowName : this.getHeaderRowNames()) {
                    headList.add(Collections.singletonList(headerRowName));
                }
                writeSheet.setHead(headList);
            }
        }
        if ("xls".equalsIgnoreCase(ext)) {
            writerBuilder.excelType(ExcelTypeEnum.XLS);
        } else if ("xlsx".equalsIgnoreCase(ext)) {
            writerBuilder.excelType(ExcelTypeEnum.XLSX);
        } else if ("csv".equalsIgnoreCase(ext)) {
            writerBuilder.excelType(ExcelTypeEnum.CSV);
        }
        ExcelWriter excelWriter = writerBuilder.autoCloseStream(Boolean.valueOf(false)).build();
        return new ExcelDataAppender(excelWriter, writeSheet);
    }

    public void export(OutputStream os) throws BaseException {
        this.appendExport(os).appendList(this.data).finish();
    }

    public Resource getTemplate() {
        return this.template;
    }

    public void setTemplate(Resource template) {
        this.template = template;
    }

    public int getHeaderRowNum() {
        return this.headerRowNum;
    }

    public void setHeaderRowNum(int headerRowNum) {
        this.headerRowNum = headerRowNum;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String[] getHeaderRowNames() {
        return this.headerRowNames;
    }

    public void setHeaderRowNames(String[] headerRowNames) {
        this.headerRowNames = headerRowNames;
    }

    public List<List<Object>> getData() {
        return this.data;
    }

    public void setData(List<List<Object>> data) {
        this.data = data;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(int defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public static class ExcelDataAppender {
        private final ExcelWriter excelWriter;
        private final WriteSheet writeSheet;

        public ExcelDataAppender(ExcelWriter excelWriter, WriteSheet writeSheet) {
            this.excelWriter = excelWriter;
            this.writeSheet = writeSheet;
        }

        public void finish() {
            this.excelWriter.finish();
        }

        public ExcelDataAppender appendArray(List<Object[]> data) {
            if (!CollectionUtils.isEmpty(data)) {
                ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
                for (Object[] datum : data) {
                    dataList.add(Arrays.asList(datum));
                }
                this.excelWriter.write(dataList, this.writeSheet);
            }
            return this;
        }

        public ExcelDataAppender appendList(List<List<Object>> data) {
            if (!CollectionUtils.isEmpty(data)) {
                this.excelWriter.write(data, this.writeSheet);
            }
            return this;
        }
    }
}

