/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.config;

import com.cyberway.msf.commons.poi.config.ImportThreadPoolProperties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@EnableConfigurationProperties(value={ImportThreadPoolProperties.class})
public class ImportThreadPoolConfig {
    public static final String BEAN_NAME = "importThreadPoolExecutor";

    @Scope
    @Bean(name={"importThreadPoolExecutor"})
    @ConditionalOnProperty(value={"import.async.enable"})
    public ThreadPoolExecutor importThreadPoolExecutor(ImportThreadPoolProperties properties) {
        return new ThreadPoolExecutor(properties.getCorePoolSize(), properties.getMaxPoolSize(), properties.getKeepAliveSeconds(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(properties.getQueueCapacity()), new ImportThreadFactory(properties), properties.getRejectedExecutionHandlerType().getValue());
    }

    static class ImportThreadFactory
    implements ThreadFactory {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final ImportThreadPoolProperties properties;
        private final AtomicInteger threadCounter = new AtomicInteger(0);

        public ImportThreadFactory(ImportThreadPoolProperties properties) {
            this.properties = properties;
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = this.properties.getThreadNamePrefix() + this.threadCounter.incrementAndGet();
            this.logger.info("create import thread:{}", (Object)threadName);
            return new Thread(r, threadName);
        }
    }
}

