/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.importer;

import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import com.cyberway.msf.commons.poi.importer.ImportExcelHandler;
import com.cyberway.msf.commons.poi.importer.ImportResult;
import com.cyberway.msf.commons.poi.util.ExcelUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractImportExcelRowHandler
implements ImportExcelHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private I18nUtils i18nUtils;

    protected I18nUtils getI18nUtils() {
        return this.i18nUtils;
    }

    protected void beforeHandleSheet(Sheet sheet) {
    }

    @Override
    public ImportResult handleSheet(Sheet sheet) {
        this.beforeHandleSheet(sheet);
        ImportResult result = new ImportResult();
        try {
            int rownum = 0;
            if (sheet.getLastRowNum() < this.getHeaderRowNum()) {
                result.setSuccess(false);
                result.setFailMsg(this.getI18nUtils().getMessage("emptyData"));
                ImportResult importResult = result;
                return importResult;
            }
            ArrayList<Row> headerRows = new ArrayList<Row>();
            for (int i = 0; i < this.getHeaderRowNum(); ++i) {
                headerRows.add(sheet.getRow(rownum++));
            }
            String checkHeaderResult = this.checkHeaderRows(headerRows);
            if (StringUtils.isNotBlank((CharSequence)checkHeaderResult)) {
                result.setSuccess(false);
                result.setFailMsg(checkHeaderResult);
                ImportResult importResult = result;
                return importResult;
            }
            if (!headerRows.isEmpty() && this.getFailCellNum() != null) {
                Cell cell = ((Row)headerRows.get(0)).createCell(this.getFailCellNum().intValue());
                cell.setCellValue(this.getI18nUtils().getMessage("failHeaderName"));
            }
            if (this.handleHeaderRows()) {
                rownum = 0;
            }
            Row row = sheet.getRow(rownum++);
            while (rownum - 1 <= sheet.getLastRowNum()) {
                if (row == null || this.checkBlankRow(row)) {
                    row = sheet.getRow(rownum++);
                    continue;
                }
                String handleResult = null;
                handleResult = !this.handleRowException() ? this.handleRow(row) : this.handleRowException(row);
                if (this.getFailCellNum() != null) {
                    Cell cell = row.createCell(this.getFailCellNum().intValue());
                    cell.setCellValue(handleResult);
                }
                if (StringUtils.isNotBlank((CharSequence)handleResult)) {
                    result.getFailRowNums().add(row.getRowNum());
                    result.getFailRowMsgs().add(handleResult);
                    result.setFailRowCount(result.getFailRowCount() + 1);
                    if (!this.skipOnRowFail()) {
                        result.setFailMsg(handleResult);
                        result.setSuccess(false);
                        ImportResult importResult = result;
                        return importResult;
                    }
                } else {
                    result.setSuccessRowCount(result.getSuccessRowCount() + 1);
                }
                row = sheet.getRow(rownum++);
                if (rownum <= this.getMaxHandleRowNum()) continue;
                break;
            }
            if (result.getSuccessRowCount() > 0) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setFailMsg(this.getI18nUtils().getMessage("allFail"));
            }
            result.setFeedback(this.getFailCellNum() != null && result.getFailRowCount() > 0);
        }
        catch (Exception e) {
            throw new BaseException("00017:\u5bfc\u5165excel\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            this.afterHandleSheet(sheet, result);
        }
        return result;
    }

    private String handleRowException(Row row) {
        String handleResult;
        try {
            handleResult = this.handleRow(row);
        }
        catch (BaseException e) {
            handleResult = e.getMessage();
            this.logger.error(handleResult, (Throwable)e);
        }
        catch (Exception e) {
            handleResult = this.getI18nUtils().getMessage("unknownError");
            this.logger.error(handleResult, (Throwable)e);
        }
        return handleResult;
    }

    protected abstract String handleRow(Row var1);

    public void doAfterHandleSheet(Sheet sheet, ImportResult result) {
        this.afterHandleSheet(sheet, result);
    }

    public void afterHandleSheet(Sheet sheet, ImportResult result) {
    }

    protected int getHeaderRowNum() {
        return 1;
    }

    protected String checkHeaderRows(List<Row> rows) {
        return null;
    }

    protected boolean handleHeaderRows() {
        return false;
    }

    private boolean checkBlankRow(Row row) {
        boolean isBlank = false;
        if (this.getFailCellNum() != null) {
            isBlank = true;
            for (int i = 0; i < this.getFailCellNum(); ++i) {
                if (ExcelUtils.isBankCell(row.getCell(i)).booleanValue()) continue;
                isBlank = false;
                break;
            }
        }
        return isBlank;
    }

    protected boolean handleRowException() {
        return true;
    }

    protected boolean skipOnRowFail() {
        return true;
    }

    protected abstract Integer getFailCellNum();

    protected int getMaxHandleRowNum() {
        return 10000;
    }
}

