/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.util;

import com.cyberway.msf.commons.core.exception.BaseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final NumberFormat DEFAULT_NUMBER_FORMAT = new DecimalFormat("#.##");

    private ExcelUtils() {
    }

    public static Sheet handleExcel(MultipartFile file, int sheetNum) {
        return ExcelUtils.handleExcel(file, sheetNum, null);
    }

    public static Sheet handleExcel(MultipartFile file, String sheetName) {
        return ExcelUtils.handleExcel(file, null, sheetName);
    }

    public static Sheet handleExcle(MultipartFile file) {
        return ExcelUtils.handleExcel(file, 0, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Sheet handleExcel(MultipartFile file, Integer sheetNum, String sheetName) {
        String ext;
        logger.info("handle Excle starts...");
        if (file == null) {
            logger.error("file is not found!");
            return null;
        }
        String filename = file.getOriginalFilename();
        if (filename == null || "".equals(filename)) {
            logger.error("file is not found!");
            return null;
        }
        int iIndex = filename.lastIndexOf(46);
        String string = ext = iIndex < 0 ? "" : filename.substring(iIndex + 1).toLowerCase();
        if (!"xlsx".equals(ext) && !"xls".equals(ext)) {
            logger.error(filename + "not a Microsoft EXCEL file");
            return null;
        }
        InputStream input = null;
        XSSFWorkbook workBook = null;
        try {
            input = file.getInputStream();
            if ("xlsx".equals(ext)) {
                workBook = new XSSFWorkbook(input);
            } else if ("xls".equals(ext)) {
                workBook = new HSSFWorkbook(input);
            }
            if (sheetNum != null) {
                Sheet sheet = workBook.getSheetAt(sheetNum.intValue());
                IOUtils.closeQuietly((Closeable)input);
                ExcelUtils.closeQuietly((Workbook)workBook);
                return sheet;
            }
            if (StringUtils.isNotEmpty((CharSequence)sheetName)) {
                Sheet sheet = workBook.getSheet(sheetName);
                IOUtils.closeQuietly((Closeable)input);
                ExcelUtils.closeQuietly((Workbook)workBook);
                return sheet;
            }
            IOUtils.closeQuietly((Closeable)input);
        }
        catch (IOException e) {
            logger.error("error :{}", (Throwable)e);
            return null;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e2) {
                logger.error("error :{}", (Throwable)e2);
                throw new BaseException("00017", "\u8bf7\u786e\u8ba4\u6587\u4ef6\u683c\u5f0f\u548c\u5185\u5bb9\u662f\u5426\u6b63\u786e");
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)input);
            ExcelUtils.closeQuietly(workBook);
        }
        ExcelUtils.closeQuietly((Workbook)workBook);
        return null;
    }

    public static String readCellString(Cell cell) {
        return ExcelUtils.readCellString(cell, null, null);
    }

    public static String readCellString(Cell cell, NumberFormat numberFormat) {
        return ExcelUtils.readCellString(cell, null, numberFormat);
    }

    public static String readCellString(Cell cell, DateFormat dateFormat) {
        return ExcelUtils.readCellString(cell, dateFormat, null);
    }

    public static String readCellString(Cell cell, DateFormat dateFormat, NumberFormat numberFormat) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    boolean booleanCellValue = cell.getBooleanCellValue();
                    return String.valueOf(booleanCellValue);
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date dateCellValue = cell.getDateCellValue();
                        String numeric = dateFormat == null ? DEFAULT_DATE_FORMAT.format(dateCellValue) : dateFormat.format(dateCellValue);
                        return dateCellValue == null ? "" : numeric;
                    }
                    double numericCellValue = cell.getNumericCellValue();
                    return numberFormat == null ? DEFAULT_NUMBER_FORMAT.format(numericCellValue) : numberFormat.format(numericCellValue);
                }
                case STRING: {
                    return StringUtils.trimToEmpty((String)cell.getStringCellValue());
                }
                case FORMULA: {
                    try {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            Date dateCellValue = cell.getDateCellValue();
                            String formula = dateFormat == null ? DEFAULT_DATE_FORMAT.format(dateCellValue) : dateFormat.format(dateCellValue);
                            return dateCellValue == null ? "" : formula;
                        }
                        double numericCellValue = cell.getNumericCellValue();
                        return numberFormat == null ? DEFAULT_NUMBER_FORMAT.format(numericCellValue) : numberFormat.format(numericCellValue);
                    }
                    catch (Exception e1) {
                        try {
                            return StringUtils.trimToEmpty((String)cell.getStringCellValue());
                        }
                        catch (Exception e2) {
                            try {
                                return String.valueOf(cell.getBooleanCellValue());
                            }
                            catch (Exception e3) {
                                logger.error("error :{}", (Throwable)e3);
                                break;
                            }
                        }
                    }
                }
            }
        }
        return "";
    }

    public static Date readCellDate(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    if (!DateUtil.isCellDateFormatted((Cell)cell)) break;
                    return cell.getDateCellValue();
                }
                case STRING: {
                    try {
                        return DEFAULT_DATE_FORMAT.parse(cell.getStringCellValue());
                    }
                    catch (ParseException e) {
                        logger.error("error :{}", (Throwable)e);
                        break;
                    }
                }
                case FORMULA: {
                    if (!DateUtil.isCellDateFormatted((Cell)cell)) break;
                    return cell.getDateCellValue();
                }
            }
        }
        return null;
    }

    public static Integer readCellInt(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    return cell.getBooleanCellValue() ? 1 : 0;
                }
                case NUMERIC: {
                    return new Double(cell.getNumericCellValue()).intValue();
                }
                case STRING: {
                    String intString = cell.getStringCellValue();
                    if (!StringUtils.isNotBlank((CharSequence)intString)) break;
                    return Integer.valueOf(intString);
                }
                case FORMULA: {
                    try {
                        return new Double(cell.getNumericCellValue()).intValue();
                    }
                    catch (Exception e) {
                        try {
                            String intString = cell.getStringCellValue();
                            if (StringUtils.isNotBlank((CharSequence)intString)) {
                                return Integer.valueOf(intString);
                            }
                        }
                        catch (Exception ex) {
                            logger.error("error :{}", (Throwable)ex);
                        }
                        break;
                    }
                }
            }
        }
        return null;
    }

    public static Double readCellDouble(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    return cell.getBooleanCellValue() ? 1.0 : 0.0;
                }
                case NUMERIC: {
                    return cell.getNumericCellValue();
                }
                case STRING: {
                    String doubleString = cell.getStringCellValue();
                    if (!StringUtils.isNotBlank((CharSequence)doubleString)) break;
                    return Double.valueOf(doubleString);
                }
                case FORMULA: {
                    try {
                        return cell.getNumericCellValue();
                    }
                    catch (Exception e) {
                        try {
                            String doubleString = cell.getStringCellValue();
                            if (StringUtils.isNotBlank((CharSequence)doubleString)) {
                                return Double.valueOf(doubleString);
                            }
                        }
                        catch (Exception ex) {
                            logger.error("error :{}", (Throwable)ex);
                        }
                        break;
                    }
                }
            }
        }
        return null;
    }

    public static Boolean readCellBoolean(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case NUMERIC: {
                    return cell.getNumericCellValue() > 0.0;
                }
                case STRING: {
                    String booleanString = cell.getStringCellValue();
                    return "true".equalsIgnoreCase(booleanString) || "y".equalsIgnoreCase(booleanString);
                }
                case FORMULA: {
                    try {
                        return cell.getBooleanCellValue();
                    }
                    catch (Exception e) {
                        logger.error("error :{}", (Throwable)e);
                        break;
                    }
                }
            }
        }
        return null;
    }

    public static Boolean isBankCell(Cell cell) {
        return cell == null || cell.getCellType() == CellType.BLANK || StringUtils.isBlank((CharSequence)ExcelUtils.readCellString(cell));
    }

    public static void closeQuietly(Workbook workbook) {
        try {
            if (workbook != null) {
                workbook.close();
            }
        }
        catch (IOException e) {
            logger.error("error :{}", (Throwable)e);
        }
    }
}

