/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.importer;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.core.i18n.I18nUtils;
import com.cyberway.msf.commons.poi.importer.ImportResult;
import com.cyberway.msf.commons.poi.model.WrapRow;
import com.cyberway.msf.commons.poi.util.Constants;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractSyncImportExcelRowHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private I18nUtils i18nUtils;

    protected I18nUtils getI18nUtils() {
        return this.i18nUtils;
    }

    protected void beforeImportExcel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportResult handleSheet(InputStream is) {
        this.beforeImportExcel();
        ImportResult importResult = new ImportResult();
        try {
            this.beforeImportExcel();
            ((ExcelReaderSheetBuilder)EasyExcelFactory.read((InputStream)is, (ReadListener)new DefaultStringDataListener(importResult)).sheet().headRowNumber(Integer.valueOf(this.getHeaderRowNum()))).doRead();
        }
        catch (Exception e) {
            importResult.setFailMsg(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
            importResult.setSuccess(false);
            this.logger.error("\u5904\u7406excel\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.afterHandleSheet(importResult);
        }
        return importResult;
    }

    public void afterHandleSheet(ImportResult importResult) {
        this.doAfterHandleSheet(importResult);
    }

    protected abstract void doAfterHandleSheet(ImportResult var1);

    public String handleRowException(WrapRow row) {
        String handleResult;
        try {
            handleResult = this.handleRow(row);
        }
        catch (BaseException e) {
            handleResult = e.getMessage();
            this.logger.error(handleResult, (Throwable)e);
        }
        catch (Exception e) {
            handleResult = this.getI18nUtils().getMessage("unknownError");
            this.logger.error(handleResult, (Throwable)e);
        }
        return handleResult;
    }

    protected abstract String handleRow(WrapRow var1);

    protected int getHeaderRowNum() {
        return Constants.DEFAULT_HEAD_ROW_NUMS;
    }

    protected String checkHeaderRows(List<WrapRow> rows) {
        return null;
    }

    protected boolean handleHeaderRows() {
        return false;
    }

    protected boolean handleRowException() {
        return true;
    }

    protected boolean skipOnRowFail() {
        return true;
    }

    protected int getMaxHandleRowNum() {
        return Constants.DEFAULT_MAX_HANDLE_ROW_NUMS;
    }

    class DefaultStringDataListener
    extends AnalysisEventListener<Map<Integer, String>> {
        private final ImportResult importResult;
        private final List<WrapRow> headRows = new ArrayList<WrapRow>();

        public DefaultStringDataListener(ImportResult importResult) {
            this.importResult = importResult;
        }

        public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
            WrapRow wrapRow = this.buildWrapRow(headMap, context);
            this.headRows.add(wrapRow);
            if (this.headRows.size() == AbstractSyncImportExcelRowHandler.this.getHeaderRowNum()) {
                String errorMsg = AbstractSyncImportExcelRowHandler.this.checkHeaderRows(this.headRows);
                this.headRows.clear();
                if (!StringUtils.isEmpty((Object)errorMsg)) {
                    throw new BaseException("\u5934\u90e8\u6821\u9a8c\u5931\u8d25:" + errorMsg);
                }
            }
        }

        public void invoke(Map<Integer, String> data, AnalysisContext context) {
            int rowNum = context.readRowHolder().getRowIndex();
            if (rowNum > AbstractSyncImportExcelRowHandler.this.getMaxHandleRowNum() + AbstractSyncImportExcelRowHandler.this.getHeaderRowNum() - 1) {
                return;
            }
            WrapRow wrapRow = this.buildWrapRow(data, context);
            if (!wrapRow.isEmptyRow()) {
                String errorMsg = !AbstractSyncImportExcelRowHandler.this.handleHeaderRows() ? AbstractSyncImportExcelRowHandler.this.handleRow(wrapRow) : AbstractSyncImportExcelRowHandler.this.handleRowException(wrapRow);
                if (!StringUtils.isEmpty((Object)errorMsg)) {
                    this.importResult.getFailRowNums().add(rowNum);
                    this.importResult.getFailRowMsgs().add(errorMsg);
                    this.importResult.setFailRowCount(this.importResult.getFailRowCount() + 1);
                    if (!AbstractSyncImportExcelRowHandler.this.skipOnRowFail()) {
                        throw new BaseException("\u672a\u8df3\u8fc7\u9519\u8bef\u7684\u884c:" + errorMsg);
                    }
                } else {
                    this.importResult.setSuccessRowCount(this.importResult.getSuccessRowCount() + 1);
                }
            }
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        private WrapRow buildWrapRow(Map<Integer, String> data, AnalysisContext context) {
            Map map = context.readSheetHolder().getCellMap();
            HashMap<Integer, ReadCellData> wrapMap = new HashMap<Integer, ReadCellData>(map.size());
            map.forEach((position, cell) -> wrapMap.put((Integer)position, (ReadCellData)cell));
            return new WrapRow(wrapMap, data, context);
        }
    }
}

