/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.util;

import com.cyberway.msf.commons.core.exception.BaseException;
import com.cyberway.msf.commons.poi.importer.ImportResult;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class ResultUtils {
    private ResultUtils() {
    }

    public static String getImportResult(ImportResult importResult) {
        ArrayList<String> failRowMsg = new ArrayList<String>();
        for (int i = 0; i < importResult.getFailRowCount(); ++i) {
            failRowMsg.add(String.format("\u7b2c%s\u884c\u5bfc\u5165\u9519\u8bef,%s", importResult.getFailRowNums().get(i) + 1, importResult.getFailRowMsgs().get(i)));
        }
        String resultFailMsg = StringUtils.isBlank((CharSequence)importResult.getFailMsg()) ? "" : importResult.getFailMsg();
        return String.format("\u6210\u529f: %s<br>%s\u5931\u8d25: %s, \u5931\u8d25\u539f\u56e0: %s", importResult.getSuccessRowCount(), StringUtils.isNotEmpty((CharSequence)importResult.getExtraMsg()) ? "\u63d0\u793a: " + importResult.getExtraMsg() + "<br>" : "", importResult.getFailRowCount(), resultFailMsg + "<br>" + StringUtils.join(failRowMsg, (String)";<br>"));
    }

    public static void generateExcel(HttpServletResponse response, String fileName, Workbook workbook) {
        try {
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            workbook.close();
        }
        catch (Exception e) {
            throw new BaseException("EXPORT_EXCEL_FAIL");
        }
    }
}

