/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.poi.util.custom;

import com.cyberway.msf.commons.poi.util.custom.Cell;
import com.cyberway.msf.commons.poi.util.custom.Row;
import com.cyberway.msf.commons.poi.util.custom.Sheep;
import com.cyberway.msf.commons.poi.util.custom.WordBook;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelService {
    private WordBook work;
    private static final int CELL_TYPE_STRING = 1;

    public ExcelService(WordBook workBook) {
        this.work = workBook;
    }

    public ExcelService(List<Map<String, Object>> sheetList) {
        this.work = new WordBook();
        ArrayList<Sheep> sheepList = new ArrayList<Sheep>();
        for (Map<String, Object> sheepMap : sheetList) {
            List list;
            String[] rowName;
            Sheep sheep = new Sheep();
            sheep.setTitle(sheepMap.get("title").toString());
            sheep.setSheepName(sheepMap.get("sheepName").toString());
            if (sheepMap.get("queryCriteriaMap") != null) {
                sheep.setQueryCriteriaMap((Map)sheepMap.get("queryCriteriaMap"));
            }
            ArrayList<Row> rowList = new ArrayList<Row>();
            Row row = new Row();
            row.setIsTitle(true);
            ArrayList<Cell> cellList = new ArrayList<Cell>();
            for (String name : rowName = (String[])sheepMap.get("rowName")) {
                Cell cell = new Cell();
                cell.setValue(name);
                cellList.add(cell);
            }
            row.setCellList(cellList);
            rowList.add(row);
            List dataList = list = (List)sheepMap.get("dataList");
            String[] fieldName = (String[])sheepMap.get("fieldName");
            for (Map dataMap : dataList) {
                row = new Row();
                cellList = new ArrayList();
                for (String name : fieldName) {
                    Cell cell = new Cell();
                    cell.setValue(dataMap.get(name) == null ? "" : dataMap.get(name).toString());
                    cellList.add(cell);
                }
                row.setCellList(cellList);
                rowList.add(row);
            }
            sheep.setRowList(rowList);
            sheepList.add(sheep);
        }
        this.work.setSheepList(sheepList);
    }

    public HSSFWorkbook exportExcel() throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (Sheep sheep : this.work.getSheepList()) {
            HSSFRow hssfRow;
            int queryCriteriaSize;
            HSSFSheet hssfSheet = workbook.createSheet(sheep.getSheepName());
            int indexNum = 0;
            if (StringUtils.isNotBlank((CharSequence)sheep.getTitle())) {
                ++indexNum;
            }
            if ((queryCriteriaSize = sheep.getQueryCriteriaMap().size()) > 0) {
                indexNum = queryCriteriaSize % 2 == 0 ? (indexNum += queryCriteriaSize / 2) : (indexNum += queryCriteriaSize / 2 + 1);
            }
            HSSFCellStyle columnTopStyle = this.getColumnTopStyle(workbook);
            HSSFCellStyle style = this.getStyle(workbook);
            int columnNum = 0;
            for (int i = indexNum; i < sheep.getRowList().size() + indexNum; ++i) {
                Row row = sheep.getRowList().get(i - indexNum);
                HSSFCellStyle tdStyle = row.getIsTitle() != false ? columnTopStyle : style;
                hssfRow = hssfSheet.createRow(i);
                if (row.getCellList().size() > columnNum) {
                    columnNum = row.getCellList().size();
                }
                for (int j = 0; j < row.getCellList().size(); ++j) {
                    Cell cell = row.getCellList().get(j);
                    HSSFCell hssfCell = hssfRow.createCell(j);
                    hssfCell.setCellType(CellType.forInt((int)1));
                    HSSFRichTextString text = new HSSFRichTextString(cell.getValue());
                    hssfCell.setCellValue((RichTextString)text);
                    hssfCell.setCellStyle(tdStyle);
                    if (cell.getRowspan() != null && cell.getRowspan() > 1 && cell.getColspan() != null && cell.getColspan() > 1) {
                        hssfSheet.addMergedRegion(new CellRangeAddress(i - cell.getRowspan() + 1, i, j - cell.getColspan() + 1, j));
                        continue;
                    }
                    if (cell.getRowspan() != null && cell.getRowspan() > 1) {
                        hssfSheet.addMergedRegion(new CellRangeAddress(i - cell.getRowspan() + 1, i, j, j));
                    }
                    if (cell.getColspan() == null || cell.getColspan() <= 1) continue;
                    hssfSheet.addMergedRegion(new CellRangeAddress(i, i, j - cell.getColspan() + 1, j));
                }
            }
            boolean isTitle = false;
            if (StringUtils.isNotBlank((CharSequence)sheep.getTitle()) && columnNum > 0) {
                HSSFRow hssfRow2 = hssfSheet.createRow(0);
                HSSFCell hssfCell = hssfRow2.createCell(0);
                hssfCell.setCellType(CellType.forInt((int)1));
                hssfCell.setCellValue(sheep.getTitle());
                hssfCell.setCellStyle(this.getColumnTitleStyle(workbook));
                hssfSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, columnNum - 1));
                isTitle = true;
            }
            if (queryCriteriaSize > 0) {
                Map<String, String> queryCriteriaMap = sheep.getQueryCriteriaMap();
                int num = 1;
                hssfRow = null;
                HSSFCellStyle queryLiftStyle = this.getColumnQueryLiftStyle(workbook);
                HSSFCellStyle queryRightStyle = this.getColumnQueryRightStyle(workbook);
                for (String key : queryCriteriaMap.keySet()) {
                    int i;
                    if (num % 2 == 1) {
                        i = num / 2 + (isTitle ? 1 : 0);
                        hssfRow = hssfSheet.createRow(i);
                        HSSFCell hssfCell0 = hssfRow.createCell(0);
                        hssfCell0.setCellType(CellType.forInt((int)1));
                        hssfCell0.setCellValue(key);
                        hssfCell0.setCellStyle(queryRightStyle);
                        hssfSheet.addMergedRegion(new CellRangeAddress(i, i, 0, 1));
                        HSSFCell hssfCell2 = hssfRow.createCell(2);
                        hssfCell2.setCellType(CellType.forInt((int)1));
                        hssfCell2.setCellValue(queryCriteriaMap.get(key));
                        hssfCell2.setCellStyle(queryLiftStyle);
                        hssfSheet.addMergedRegion(new CellRangeAddress(i, i, 2, 3));
                    }
                    if (num % 2 == 0) {
                        i = num / 2 - 1 + (isTitle ? 1 : 0);
                        HSSFCell hssfCell4 = hssfRow.createCell(4);
                        hssfCell4.setCellType(CellType.forInt((int)1));
                        hssfCell4.setCellValue(key);
                        hssfCell4.setCellStyle(queryRightStyle);
                        hssfSheet.addMergedRegion(new CellRangeAddress(i, i, 4, 5));
                        HSSFCell hssfCell6 = hssfRow.createCell(6);
                        hssfCell6.setCellType(CellType.forInt((int)1));
                        hssfCell6.setCellValue(queryCriteriaMap.get(key));
                        hssfCell6.setCellStyle(style);
                        hssfCell6.setCellStyle(queryLiftStyle);
                        hssfSheet.addMergedRegion(new CellRangeAddress(i, i, 6, 7));
                    }
                    ++num;
                }
            }
            HSSFCellStyle queryRightStyle = this.getColumnQueryRightStyle(workbook);
            for (Cell cell : sheep.getCells()) {
                HSSFCell hssfCell;
                HSSFRow hssfRow3 = hssfSheet.getRow(cell.getRowNum().intValue());
                if (hssfRow3 == null) {
                    hssfRow3 = hssfSheet.createRow(cell.getRowNum().intValue());
                }
                if ((hssfCell = hssfRow3.getCell(cell.getColNum().intValue())) == null) {
                    hssfCell = hssfRow3.createCell(cell.getColNum().intValue());
                }
                hssfCell.setCellType(CellType.forInt((int)1));
                hssfCell.setCellValue(cell.getValue());
                hssfCell.setCellStyle(queryRightStyle);
            }
            if (columnNum < 8) {
                columnNum = 8;
            }
            for (int colNum = 0; colNum < columnNum; ++colNum) {
                int columnWidth = hssfSheet.getColumnWidth(colNum) / 256;
                for (int rowNum = 0; rowNum < hssfSheet.getLastRowNum(); ++rowNum) {
                    int length;
                    HSSFCell currentCell;
                    HSSFRow currentRow = hssfSheet.getRow(rowNum) == null ? hssfSheet.createRow(rowNum) : hssfSheet.getRow(rowNum);
                    if (currentRow.getCell(colNum) == null || (currentCell = currentRow.getCell(colNum)).getCellType() != CellType.forInt((int)1) || columnWidth >= (length = currentCell.getStringCellValue().getBytes().length)) continue;
                    columnWidth = length;
                }
                if (colNum == 0) {
                    hssfSheet.setColumnWidth(colNum, (columnWidth - 2) * 256);
                    continue;
                }
                hssfSheet.setColumnWidth(colNum, (columnWidth + 4) * 256);
            }
        }
        return workbook;
    }

    public HSSFCellStyle getColumnTitleStyle(HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setFontName("Courier New");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public HSSFCellStyle getColumnQueryLiftStyle(HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setFontName("Courier New");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public HSSFCellStyle getColumnQueryRightStyle(HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setFontName("Courier New");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public HSSFCellStyle getColumnTopStyle(HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setFontName("Courier New");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    public HSSFCellStyle getStyle(HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontName("Courier New");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        style.setFont(font);
        style.setWrapText(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFDataFormat format = workbook.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        return style;
    }
}

