/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.sql;

import com.cyberway.msf.commons.sql.DatabaseType;
import com.cyberway.msf.commons.sql.FormatStyle;
import org.apache.commons.lang3.StringUtils;

public class SqlHelper {
    protected static final String WITHNOLOCK = "WITH(NOLOCK)";
    private static DatabaseType databaseType = DatabaseType.mysql;

    public static String format(String sql) {
        return FormatStyle.BASIC.getFormatter().format(sql);
    }

    public static DatabaseType getDatabaseType() {
        if (databaseType == null) {
            databaseType = DatabaseType.mysql;
        }
        return databaseType;
    }

    public static String locate(String expr1, String expr2) {
        return SqlHelper.locate(databaseType, expr1, expr2);
    }

    public static String locate(DatabaseType databaseType, String expr1, String expr2) {
        String sql = "";
        switch (SqlHelper.getDatabaseType()) {
            case mysql: {
                sql = String.format("locate(%s, %s)", expr1, expr2);
                break;
            }
            case sqlserver: {
                sql = String.format("charindex(%s, %s)", expr1, expr2);
                break;
            }
            case oracle: {
                sql = String.format("instr(%s, %s)", expr2, expr1);
                break;
            }
        }
        return sql;
    }

    public static String ifnull(String expr1, String expr2) {
        return SqlHelper.ifnull(databaseType, expr1, expr2);
    }

    public static String ifnull(String expr1, String expr2, String expr3) {
        String sql = SqlHelper.ifnull(expr1, expr2);
        sql = SqlHelper.ifnull(sql, expr3);
        return sql;
    }

    public static String ifnull(DatabaseType databaseType, String expr1, String expr2) {
        String sql = "";
        switch (databaseType) {
            case mysql: {
                sql = String.format("ifnull(%s, %s)", expr1, expr2);
                break;
            }
            case sqlserver: {
                sql = String.format("isnull(%s, %s)", expr1, expr2);
                break;
            }
            case oracle: {
                sql = String.format("nvl(%s, %s)", expr1, expr2);
                break;
            }
        }
        return sql;
    }

    public static String ifnull(DatabaseType databaseType, String expr1, String expr2, String expr3) {
        String sql = SqlHelper.ifnull(databaseType, expr1, expr2);
        sql = SqlHelper.ifnull(databaseType, sql, expr3);
        return sql;
    }

    public static String concat(String ... exprs) {
        return SqlHelper.concat(databaseType, exprs);
    }

    public static String concat(DatabaseType databaseType, String ... exprs) {
        String sql = "";
        switch (databaseType) {
            case mysql: {
                sql = String.format("concat(%s)", StringUtils.join((Object[])exprs, (String)","));
                break;
            }
            case sqlserver: {
                sql = StringUtils.join((Object[])exprs, (String)"+");
                break;
            }
            case oracle: {
                sql = StringUtils.join((Object[])exprs, (String)"||");
                break;
            }
        }
        return sql;
    }

    public static String withNoLock() {
        return SqlHelper.withNoLock(databaseType);
    }

    public static String withNoLock(DatabaseType databaseType) {
        if (DatabaseType.sqlserver.equals((Object)databaseType)) {
            return "with(nolock)";
        }
        return "";
    }

    public static String substring(String expr, int start, int len) {
        return SqlHelper.substring(databaseType, expr, start, len);
    }

    public static String substring(DatabaseType databaseType, String expr, int start, int len) {
        String sql = "";
        switch (databaseType) {
            case mysql: {
                sql = String.format("substring(%s,%s,%s)", expr, start, len);
                break;
            }
            case sqlserver: {
                sql = String.format("substring(%s,%s,%s)", expr, start + 1, len);
                break;
            }
            case oracle: {
                sql = String.format("substr(%s,%s,%s)", expr, start, len);
                break;
            }
        }
        return sql;
    }

    public static String groupConcat(String expr) {
        return SqlHelper.groupConcat(databaseType, expr);
    }

    public static String groupConcat(DatabaseType databaseType, String expr) {
        String sql = "";
        switch (databaseType) {
            case mysql: {
                sql = String.format("group_concat(%s)", expr);
                break;
            }
            case oracle: {
                sql = String.format("wm_concat(%s)", expr);
                break;
            }
        }
        return sql;
    }

    public static String toLimitSql(String originalSql, int limit) {
        return SqlHelper.toLimitSql(databaseType, originalSql, limit);
    }

    public static String toLimitSql(DatabaseType databaseType, String originalSql, int limit) {
        String sql = originalSql;
        switch (databaseType) {
            case mysql: {
                sql = String.format("%s limit %s", originalSql, limit);
                break;
            }
            case sqlserver: {
                sql = String.format("select top %s%s", limit, StringUtils.removeStartIgnoreCase((String)originalSql.trim(), (String)"select"));
                break;
            }
            case oracle: {
                sql = String.format("select * from (%s) where rownum<=%s", originalSql, limit);
                break;
            }
        }
        return sql;
    }

    public static String cast(String expr, String type) {
        return SqlHelper.cast(databaseType, expr, type);
    }

    public static String cast(DatabaseType databaseType, String expr, String type) {
        String sql = "";
        String toType = type;
        if (DatabaseType.mysql.equals((Object)databaseType)) {
            if (StringUtils.containsIgnoreCase((CharSequence)type, (CharSequence)"numeric")) {
                toType = StringUtils.replace((String)type.toLowerCase(), (String)"numeric", (String)"decimal");
            }
            if (StringUtils.containsIgnoreCase((CharSequence)type, (CharSequence)"char")) {
                toType = "char";
            }
        }
        sql = String.format("cast(%s as %s)", expr, toType);
        return sql;
    }
}

