/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.sql;

import com.cyberway.msf.commons.sql.Formatter;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class DdlFormatterImpl
implements Formatter {
    public static final DdlFormatterImpl INSTANCE = new DdlFormatterImpl();
    private static final String CREATE_TABLE = "create table";
    private static final String ALTER_TABLE = "alter table";
    private static final String COMMENT_ON = "comment on";

    @Override
    public String format(String sql) {
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return sql;
        }
        if (sql.toLowerCase(Locale.ROOT).startsWith(CREATE_TABLE)) {
            return this.formatCreateTable(sql);
        }
        if (sql.toLowerCase(Locale.ROOT).startsWith(ALTER_TABLE)) {
            return this.formatAlterTable(sql);
        }
        return sql.toLowerCase(Locale.ROOT).startsWith(COMMENT_ON) ? this.formatCommentOn(sql) : "\n    " + sql;
    }

    private String formatCommentOn(String sql) {
        StringBuilder result = new StringBuilder(60).append("\n    ");
        StringTokenizer tokens = new StringTokenizer(sql, " '[]\"", true);
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(token);
            if (DdlFormatterImpl.isQuote(token)) {
                quoted = !quoted;
                continue;
            }
            if (quoted || !"is".equals(token)) continue;
            result.append("\n       ");
        }
        return result.toString();
    }

    private String formatAlterTable(String sql) {
        StringBuilder result = new StringBuilder(60).append("\n    ");
        StringTokenizer tokens = new StringTokenizer(sql, " (,)'[]\"", true);
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (DdlFormatterImpl.isQuote(token)) {
                quoted = !quoted;
            } else if (!quoted && DdlFormatterImpl.isBreak(token)) {
                result.append("\n        ");
            }
            result.append(token);
        }
        return result.toString();
    }

    private String formatCreateTable(String sql) {
        StringBuilder result = new StringBuilder(60).append("\n    ");
        StringTokenizer tokens = new StringTokenizer(sql, "(,)'[]\"", true);
        int depth = 0;
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (DdlFormatterImpl.isQuote(token)) {
                quoted = !quoted;
                result.append(token);
                continue;
            }
            if (quoted) {
                result.append(token);
                continue;
            }
            if (")".equals(token) && --depth == 0) {
                result.append("\n    ");
            }
            result.append(token);
            if (",".equals(token) && depth == 1) {
                result.append("\n       ");
            }
            if (!"(".equals(token) || ++depth != 1) continue;
            result.append("\n        ");
        }
        return result.toString();
    }

    private static boolean isBreak(String token) {
        return "drop".equals(token) || "add".equals(token) || "references".equals(token) || "foreign".equals(token) || "on".equals(token);
    }

    private static boolean isQuote(String tok) {
        return "\"".equals(tok) || "`".equals(tok) || "]".equals(tok) || "[".equals(tok) || "'".equals(tok);
    }
}

