/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.transaction.seata.feign.hystrix;

import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import io.seata.core.context.RootContext;
import java.util.concurrent.Callable;

public class SeataHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private HystrixConcurrencyStrategy delegate = HystrixPlugins.getInstance().getConcurrencyStrategy();

    public SeataHystrixConcurrencyStrategy() {
        HystrixPlugins.reset();
        HystrixPlugins.getInstance().registerConcurrencyStrategy((HystrixConcurrencyStrategy)this);
    }

    public <K> Callable<K> wrapCallable(Callable<K> c) {
        if (c instanceof SeataContextCallable) {
            return c;
        }
        Callable wrappedCallable = this.delegate != null ? this.delegate.wrapCallable(c) : c;
        if (wrappedCallable instanceof SeataContextCallable) {
            return wrappedCallable;
        }
        return new SeataContextCallable(wrappedCallable);
    }

    private static class SeataContextCallable<K>
    implements Callable<K> {
        private final Callable<K> actual;
        private final String xid;

        SeataContextCallable(Callable<K> actual) {
            this.actual = actual;
            this.xid = RootContext.getXID();
        }

        @Override
        public K call() throws Exception {
            try {
                RootContext.bind((String)this.xid);
                K k = this.actual.call();
                return k;
            }
            finally {
                RootContext.unbind();
            }
        }
    }
}

