/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.core.model.menu;

import java.util.Arrays;
import java.util.List;

public enum MenuType {
    NAV("\u540e\u53f0\u5bfc\u822a\u83dc\u5355", 0),
    FIRST("\u540e\u53f0\u4e00\u7ea7\u83dc\u5355", 1),
    SECOND("\u540e\u53f0\u4e8c\u7ea7\u83dc\u5355", 2),
    BUTTON("\u540e\u53f0\u6309\u94ae", 3),
    DATA("\u540e\u53f0\u6570\u636e\u6761\u76ee", 4),
    APP_SHORTCUT("APP\u5feb\u6377\u83dc\u5355", 10),
    APP_NAV("APP\u5bfc\u822a\u83dc\u5355", 11),
    APP_USER("APP\u6211\u7684\u83dc\u5355", 12);

    private String name;
    private Integer value;

    private MenuType(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (MenuType m : MenuType.values()) {
            if (!value.equals(m.value)) continue;
            return m.name;
        }
        return null;
    }

    public static List<Integer> appValues() {
        return Arrays.asList(MenuType.APP_SHORTCUT.value, MenuType.APP_NAV.value, MenuType.APP_USER.value);
    }

    public static List<Integer> webValues() {
        return Arrays.asList(MenuType.NAV.value, MenuType.FIRST.value, MenuType.SECOND.value, MenuType.BUTTON.value, MenuType.DATA.value);
    }

    public static List<Integer> webShowValues() {
        return Arrays.asList(MenuType.NAV.value, MenuType.FIRST.value, MenuType.SECOND.value, MenuType.BUTTON.value);
    }

    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        return this.value;
    }
}

