/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.core.model.settings.vo;

import com.cyberway.msf.commons.model.util.LocalizationDetail;
import com.cyberway.msf.core.model.settings.SystemSettings;
import com.cyberway.msf.core.model.settings.vo.PasswordSettings;
import com.cyberway.msf.core.model.settings.vo.SessionSettings;
import com.cyberway.msf.core.model.settings.vo.UserPreference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemSettingsVO {
    private static final long serialVersionUID = -7352472980517631985L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemSettingsVO.class);
    private String palette;
    private String systemName;
    private String systemNameKey;
    private String logo;
    private String copyright;
    private UserPreference userPreference;
    private SessionSettings session;
    private PasswordSettings password;
    private LocalizationDetail localization;
    private Integer menuStyle;
    private String description;

    public String getPalette() {
        return this.palette;
    }

    public void setPalette(String palette) {
        this.palette = palette;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getSystemNameKey() {
        return this.systemNameKey;
    }

    public void setSystemNameKey(String systemNameKey) {
        this.systemNameKey = systemNameKey;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public UserPreference getUserPreference() {
        return this.userPreference;
    }

    public void setUserPreference(UserPreference userPreference) {
        this.userPreference = userPreference;
    }

    public SessionSettings getSession() {
        return this.session;
    }

    public void setSession(SessionSettings session) {
        this.session = session;
    }

    public PasswordSettings getPassword() {
        return this.password;
    }

    public void setPassword(PasswordSettings password) {
        this.password = password;
    }

    public LocalizationDetail getLocalization() {
        return this.localization;
    }

    public void setLocalization(LocalizationDetail localization) {
        this.localization = localization;
    }

    public Integer getMenuStyle() {
        return this.menuStyle;
    }

    public void setMenuStyle(Integer menuStyle) {
        this.menuStyle = menuStyle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static SystemSettingsVO fromSystemSettings(SystemSettings systemSettings) {
        SystemSettingsVO settings = new SystemSettingsVO();
        settings.setPalette(systemSettings.getSettingsPalette());
        settings.setSystemName(systemSettings.getSettingsSystemName());
        settings.setSystemNameKey(systemSettings.getSettingsSystemNameKey());
        settings.setLogo(systemSettings.getSettingsLogo());
        settings.setCopyright(systemSettings.getSettingsCopyright());
        settings.setMenuStyle(systemSettings.getMenuStyle());
        UserPreference userPreference = new UserPreference();
        userPreference.setDateFormat(systemSettings.getSettingsDateFormat());
        userPreference.setTheme(systemSettings.getSettingsTheme());
        userPreference.setTimeFormat(systemSettings.getSettingsTimeFormat());
        settings.setUserPreference(userPreference);
        SessionSettings sessionSettings = new SessionSettings();
        sessionSettings.setLockIp(systemSettings.getSettingsSessionLockIp() == null ? null : Boolean.valueOf(systemSettings.getSettingsSessionLockIp() == 1));
        sessionSettings.setTimeout(systemSettings.getSettingsSessionTimeout());
        settings.setSession(sessionSettings);
        PasswordSettings passwordSettings = new PasswordSettings();
        passwordSettings.setIndate(systemSettings.getSettingsPasswordIndate());
        passwordSettings.setHistory(systemSettings.getSettingsPasswordHistory());
        passwordSettings.setMinLength(systemSettings.getSettingsPasswordMinLength());
        PasswordSettings.Complexity complexity = null;
        try {
            complexity = PasswordSettings.Complexity.valueOf(systemSettings.getSettingsPasswordComplexity());
        }
        catch (Exception e) {
            LOGGER.warn(" No enum constant Complexity{}", (Object)systemSettings.getSettingsPasswordComplexity());
        }
        passwordSettings.setComplexity(complexity);
        passwordSettings.setMaxTry(systemSettings.getSettingsPasswordMaxTry());
        passwordSettings.setTimeOfLock(systemSettings.getSettingsPasswordTimeOfLock());
        settings.setPassword(passwordSettings);
        LocalizationDetail localizationDetail = new LocalizationDetail(systemSettings.getSettingsLocation(), systemSettings.getSettingsLanguage(), systemSettings.getSettingsTimeZone());
        settings.setLocalization(localizationDetail);
        return settings;
    }

    public String toString() {
        return "SystemSettingsVO{palette='" + this.palette + '\'' + ", systemName='" + this.systemName + '\'' + ", systemNameKey='" + this.systemNameKey + '\'' + ", logo='" + this.logo + '\'' + ", copyright='" + this.copyright + '\'' + ", userPreference=" + this.userPreference + ", session=" + this.session + ", password=" + this.password + ", localization=" + this.localization + ", menuStyle=" + this.menuStyle + ", description='" + this.description + '\'' + '}';
    }
}

