/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.core.model.settings.vo;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PasswordSettings
implements Serializable {
    private static final long serialVersionUID = 8906777824077343714L;
    public static final Pattern COMPLEXITY_COMPLEX_PATTERN = Pattern.compile("^(?!\\D+$)(?![^a-zA-Z]+$)\\S+$");
    public static final Pattern COMPLEXITY_COMPLEXCASESENSITIVE_PATTERN = Pattern.compile("^(?!\\D+$)(?![^a-z]+$)(?![^A-Z]+$)\\S+$");
    public static final String SPECIAL_CHARS = "~!@#$%^&*()+=|{}:;\"'.,?<>\\[\\]/\\\\_-";
    public static final Pattern COMPLEXITY_COMPLEXCASESENSITIVESPECIAL_PATTERN = Pattern.compile(MessageFormat.format("^(?=.*[{0}])(?=.*[{1}])(?=.*[{2}])(?=.*[{3}])\\S+$", "\\d", "a-z", "A-Z", "~!@#$%^&*()+=|{}:;\"'.,?<>\\[\\]/\\\\_-"));
    public static final String[] COMPLEXCASESENSITIVESPECIALNUMBER_CHARS = new String[]{"1234567890", "abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "~!@#$%^&*()+=|{}:;\"'.,?<>[]/\\_-"};
    public static final List<Integer> INDATES = Arrays.asList(-1, 30, 60, 90, 180, 365);
    public static final List<Integer> HISTORYS = Arrays.asList(-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
    public static final List<Integer> MINLENGTHS = Arrays.asList(5, 6, 7, 8, 9, 10);
    public static final List<Integer> MAXTRYS = Arrays.asList(-1, 3, 4, 5, 6, 7, 8, 9, 10);
    public static final List<Integer> TIME_OF_LOCKS = Arrays.asList(-1, 15, 30, 60, 1440);
    private Integer indate = 90;
    private Integer history = 3;
    private Integer minLength = 6;
    private Complexity complexity = Complexity.ComplexCaseSensitiveSpecialNumber;
    private QuestionSecurity questionSecurity = QuestionSecurity.CanNotContainsPassword;
    private Integer maxTry = 5;
    private Integer timeOfLock = 1440;
    private String helpMsg;
    private String helpLink;
    private String backupHome;
    private Integer employeeIndate = 90;
    private Integer employeeHistory = 3;
    private Integer employeeMinLength = 6;
    private Complexity employeeComplexity = Complexity.ComplexCaseSensitiveSpecial;
    private Integer employeeMaxTry = 5;
    private Integer employeeTimeOfLock = 1440;

    public Integer getIndate() {
        return this.indate;
    }

    public void setIndate(Integer indate) {
        this.indate = indate;
    }

    public Integer getHistory() {
        return this.history;
    }

    public void setHistory(Integer history) {
        this.history = history;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Complexity getComplexity() {
        return this.complexity;
    }

    public void setComplexity(Complexity complexity) {
        this.complexity = complexity;
    }

    public QuestionSecurity getQuestionSecurity() {
        return this.questionSecurity;
    }

    public void setQuestionSecurity(QuestionSecurity questionSecurity) {
        this.questionSecurity = questionSecurity;
    }

    public Integer getMaxTry() {
        return this.maxTry;
    }

    public void setMaxTry(Integer maxTry) {
        this.maxTry = maxTry;
    }

    public Integer getTimeOfLock() {
        return this.timeOfLock;
    }

    public void setTimeOfLock(Integer timeOfLock) {
        this.timeOfLock = timeOfLock;
    }

    public String getHelpMsg() {
        return this.helpMsg;
    }

    public void setHelpMsg(String helpMsg) {
        this.helpMsg = helpMsg;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

    public String getBackupHome() {
        return this.backupHome;
    }

    public void setBackupHome(String backupHome) {
        this.backupHome = backupHome;
    }

    public Integer getEmployeeIndate() {
        return this.employeeIndate;
    }

    public void setEmployeeIndate(Integer employeeIndate) {
        this.employeeIndate = employeeIndate;
    }

    public Integer getEmployeeHistory() {
        return this.employeeHistory;
    }

    public void setEmployeeHistory(Integer employeeHistory) {
        this.employeeHistory = employeeHistory;
    }

    public Integer getEmployeeMinLength() {
        return this.employeeMinLength;
    }

    public void setEmployeeMinLength(Integer employeeMinLength) {
        this.employeeMinLength = employeeMinLength;
    }

    public Complexity getEmployeeComplexity() {
        return this.employeeComplexity;
    }

    public void setEmployeeComplexity(Complexity employeeComplexity) {
        this.employeeComplexity = employeeComplexity;
    }

    public Integer getEmployeeMaxTry() {
        return this.employeeMaxTry;
    }

    public void setEmployeeMaxTry(Integer employeeMaxTry) {
        this.employeeMaxTry = employeeMaxTry;
    }

    public Integer getEmployeeTimeOfLock() {
        return this.employeeTimeOfLock;
    }

    public void setEmployeeTimeOfLock(Integer employeeTimeOfLock) {
        this.employeeTimeOfLock = employeeTimeOfLock;
    }

    public static enum QuestionSecurity {
        CanNotContainsPassword;

    }

    public static enum Complexity {
        Complex("\u5fc5\u987b\u6df7\u5408\u4f7f\u7528\u5b57\u6bcd\u548c\u6570\u5b57"),
        ComplexCaseSensitive("\u5fc5\u987b\u6df7\u5408\u4f7f\u7528\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57"),
        ComplexCaseSensitiveSpecial("\u5fc5\u987b\u6df7\u5408\u4f7f\u7528\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u7279\u6b8a\u7b26\u53f7"),
        ComplexCaseSensitiveSpecialNumber("\u5fc5\u987b\u6df7\u5408\u4f7f\u7528\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u7279\u6b8a\u7b26\u53f7\u81f3\u5c11\u4e09\u79cd"),
        UnLimit("\u65e0\u9650\u5236");

        private String name;

        private Complexity(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean matches(String text) {
            boolean matches = true;
            switch (this) {
                case Complex: {
                    matches = COMPLEXITY_COMPLEX_PATTERN.matcher(text).matches();
                    break;
                }
                case ComplexCaseSensitive: {
                    matches = COMPLEXITY_COMPLEXCASESENSITIVE_PATTERN.matcher(text).matches();
                    break;
                }
                case ComplexCaseSensitiveSpecial: {
                    matches = COMPLEXITY_COMPLEXCASESENSITIVESPECIAL_PATTERN.matcher(text).matches();
                    break;
                }
                case ComplexCaseSensitiveSpecialNumber: {
                    matches = Arrays.stream(COMPLEXCASESENSITIVESPECIALNUMBER_CHARS).filter(s -> StringUtils.containsAny((CharSequence)text, (CharSequence)s)).count() >= 3L;
                    break;
                }
            }
            return matches;
        }

        public Pattern getPattern() {
            if (Objects.equals((Object)this, (Object)Complex)) {
                return COMPLEXITY_COMPLEX_PATTERN;
            }
            if (Objects.equals((Object)this, (Object)ComplexCaseSensitive)) {
                return COMPLEXITY_COMPLEXCASESENSITIVE_PATTERN;
            }
            if (Objects.equals((Object)this, (Object)ComplexCaseSensitiveSpecial)) {
                return COMPLEXITY_COMPLEXCASESENSITIVESPECIAL_PATTERN;
            }
            return null;
        }
    }
}

