/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.mq.interceptor;

import com.cyberway.msf.mq.interceptor.FrameworkEventInterceptor;
import com.cyberway.msf.mq.interceptor.NotifyEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class NotifyEventListenerConfiguration
implements ApplicationListener<NotifyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyEventListenerConfiguration.class);
    private final List<FrameworkEventInterceptor> interceptors;

    public NotifyEventListenerConfiguration(List<FrameworkEventInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void onApplicationEvent(NotifyEvent event) {
        switch (event.getType()) {
            case SEND_BEFORE: {
                this.executeSendBefore(event);
                break;
            }
            case SEND_AFTER: {
                this.executeSendAfter(event);
                break;
            }
            case CONSUME_BEFORE: {
                this.executeConsumeBefore(event);
                break;
            }
            case CONSUME_AFTER: {
                this.executeConsumeAfter(event);
                break;
            }
        }
    }

    private void executeConsumeAfter(NotifyEvent event) {
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            for (FrameworkEventInterceptor interceptor : this.interceptors) {
                try {
                    interceptor.executeConsumeAfter(event.getSourceEventCopy());
                }
                catch (Exception e) {
                    LOGGER.warn("failed to executeConsumeAfter", (Throwable)e);
                }
            }
        }
    }

    private void executeConsumeBefore(NotifyEvent event) {
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            for (FrameworkEventInterceptor interceptor : this.interceptors) {
                try {
                    interceptor.executeConsumeBefore(event.getSourceEventCopy());
                }
                catch (Exception e) {
                    LOGGER.warn("failed to executeConsumeBefore", (Throwable)e);
                }
            }
        }
    }

    private void executeSendAfter(NotifyEvent event) {
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            for (FrameworkEventInterceptor interceptor : this.interceptors) {
                try {
                    interceptor.executeSendAfter(event.getSourceEventCopy());
                }
                catch (Exception e) {
                    LOGGER.warn("failed to executeSendAfter", (Throwable)e);
                }
            }
        }
    }

    private void executeSendBefore(NotifyEvent event) {
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            for (FrameworkEventInterceptor interceptor : this.interceptors) {
                try {
                    interceptor.executeSendBefore(event.getSourceEventCopy());
                }
                catch (Exception e) {
                    LOGGER.warn("failed to executeSendBefore", (Throwable)e);
                }
            }
        }
    }
}

