/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.interceptor;

import com.cyberway.msf.interceptor.BasePublishPostProcessor;
import com.cyberway.msf.mq.interceptor.NotifyEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Correlation;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.context.ApplicationContext;

public class BeforePublishPostProcessor
extends BasePublishPostProcessor
implements MessagePostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeforePublishPostProcessor.class);
    private ApplicationContext applicationContext;
    private final Jackson2JsonMessageConverter jackson2JsonMessageConverter;

    public BeforePublishPostProcessor(ApplicationContext applicationContext, Jackson2JsonMessageConverter jackson2JsonMessageConverter) {
        super(applicationContext, jackson2JsonMessageConverter);
        this.applicationContext = applicationContext;
        this.jackson2JsonMessageConverter = jackson2JsonMessageConverter;
    }

    public Message postProcessMessage(Message message) throws AmqpException {
        try {
            return this.postProcessMessage(message, NotifyEventType.SEND_BEFORE);
        }
        catch (Exception e) {
            LOGGER.error("postProcessMessage error", (Throwable)e);
            return message;
        }
    }

    public Message postProcessMessage(Message message, Correlation correlation) {
        try {
            return this.postProcessMessage(message, NotifyEventType.SEND_BEFORE);
        }
        catch (Exception e) {
            LOGGER.error("postProcessMessage error", (Throwable)e);
            return message;
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

