/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.interceptor;

import com.cyberway.msf.mq.interceptor.NotifyEvent;
import com.cyberway.msf.mq.interceptor.NotifyEventType;
import com.cyberway.msf.mq.model.BeanEvent;
import com.cyberway.msf.mq.model.FrameworkEvent;
import java.util.Map;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class BasePublishPostProcessor {
    private final ApplicationContext applicationContext;
    private final Jackson2JsonMessageConverter jackson2JsonMessageConverter;

    public BasePublishPostProcessor(ApplicationContext applicationContext, Jackson2JsonMessageConverter jackson2JsonMessageConverter) {
        this.applicationContext = applicationContext;
        this.jackson2JsonMessageConverter = jackson2JsonMessageConverter;
    }

    public Message postProcessMessage(Message message, NotifyEventType type) {
        BeanEvent beanEvent = (BeanEvent)this.jackson2JsonMessageConverter.fromMessage(message);
        message.getMessageProperties().getHeaders().forEach((key, val) -> {
            if (val instanceof String) {
                beanEvent.setMetaData(key, (String)val);
            }
        });
        NotifyEvent notifyEvent = new NotifyEvent((Object)message, type, (FrameworkEvent)beanEvent);
        this.applicationContext.publishEvent((ApplicationEvent)notifyEvent);
        Map metaDataMap = notifyEvent.getSourceEventCopy().getAllMetaData();
        metaDataMap.forEach((key, val) -> message.getMessageProperties().setHeader(key, val));
        Message newMessage = this.jackson2JsonMessageConverter.toMessage((Object)notifyEvent.getSourceEventCopy(), message.getMessageProperties());
        metaDataMap.clear();
        return newMessage;
    }
}

