/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.rabbitmq.service;

import com.cyberway.msf.mq.annotation.TopicName;
import com.cyberway.msf.mq.config.FrameworkEventConfigProperties;
import com.cyberway.msf.mq.model.FrameworkEvent;
import org.apache.commons.lang3.StringUtils;

public class ExchangeRoutingNameStrategy {
    public static String findExchangeName(Class<? extends FrameworkEvent> event, FrameworkEventConfigProperties frameworkEventConfigProperties) {
        TopicName exchangeName = event.getAnnotation(TopicName.class);
        if (exchangeName != null && StringUtils.isNotEmpty((CharSequence)exchangeName.value())) {
            return exchangeName.value();
        }
        if (StringUtils.isNotBlank((CharSequence)frameworkEventConfigProperties.getRabbitmq().getDefaultExchange())) {
            return frameworkEventConfigProperties.getRabbitmq().getDefaultExchange();
        }
        return event.getSimpleName();
    }

    public static String findRoutingKey(Class<? extends FrameworkEvent> event, FrameworkEventConfigProperties frameworkEventConfigProperties) {
        return StringUtils.defaultString((String)frameworkEventConfigProperties.getRabbitmq().getRoutingKeyPrefix()) + event.getSimpleName() + StringUtils.defaultString((String)frameworkEventConfigProperties.getRabbitmq().getRoutingKeySuffix());
    }

    public static String findExchangeType(Class<? extends FrameworkEvent> event) {
        TopicName topicName = event.getAnnotation(TopicName.class);
        if (topicName != null) {
            return topicName.type();
        }
        return null;
    }
}

