/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.rabbitmq.config;

import com.cyberway.msf.mq.config.ConditionalOnMutilPropertyValue;
import com.cyberway.msf.mq.config.FrameworkEventConfigProperties;
import com.cyberway.msf.mq.service.FrameworkEventService;
import com.cyberway.msf.mq.service.ListenerLifecycle;
import com.cyberway.msf.rabbitmq.service.RabbitListenerLifecycle;
import com.cyberway.msf.rabbitmq.service.RabbitMQFrameworkEventServiceImpl;
import com.rabbitmq.client.ConnectionFactory;
import java.time.Duration;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnMutilPropertyValue(name={"framework.event.type", "framework.event.types"}, havingValue={"rabbitmq"})
public class RabbitmqEventConfig {
    @Bean
    @Primary
    public FrameworkEventService rabbitmqFrameworkEventService(FrameworkEventConfigProperties frameworkEventConfigProperties, RabbitTemplate template) {
        return new RabbitMQFrameworkEventServiceImpl(frameworkEventConfigProperties, template);
    }

    @Bean
    @Primary
    public CachingConnectionFactory rabbitConnectionFactory(RabbitProperties properties, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) throws Exception {
        PropertyMapper map = PropertyMapper.get();
        CachingConnectionFactory factory = new CachingConnectionFactory((ConnectionFactory)this.getRabbitConnectionFactoryBean(properties).getObject());
        map.from(() -> ((RabbitProperties)properties).determineAddresses()).to(arg_0 -> ((CachingConnectionFactory)factory).setAddresses(arg_0));
        map.from(() -> ((RabbitProperties)properties).isPublisherReturns()).to(arg_0 -> ((CachingConnectionFactory)factory).setPublisherReturns(arg_0));
        map.from(() -> ((RabbitProperties)properties).getPublisherConfirmType()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setPublisherConfirmType(arg_0));
        RabbitProperties.Cache.Channel channel = properties.getCache().getChannel();
        map.from(() -> ((RabbitProperties.Cache.Channel)channel).getSize()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setChannelCacheSize(arg_0));
        map.from(() -> ((RabbitProperties.Cache.Channel)channel).getCheckoutTimeout()).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((CachingConnectionFactory)factory).setChannelCheckoutTimeout(arg_0));
        RabbitProperties.Cache.Connection connection = properties.getCache().getConnection();
        map.from(() -> ((RabbitProperties.Cache.Connection)connection).getMode()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setCacheMode(arg_0));
        map.from(() -> ((RabbitProperties.Cache.Connection)connection).getSize()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionCacheSize(arg_0));
        map.from(() -> connectionNameStrategy.getIfUnique()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionNameStrategy(arg_0));
        return factory;
    }

    private RabbitConnectionFactoryBean getRabbitConnectionFactoryBean(RabbitProperties properties) throws Exception {
        PropertyMapper map = PropertyMapper.get();
        RabbitConnectionFactoryBean factory = new RabbitConnectionFactoryBean();
        map.from(() -> ((RabbitProperties)properties).determineHost()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setHost(arg_0));
        map.from(() -> ((RabbitProperties)properties).determinePort()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPort(arg_0));
        map.from(() -> ((RabbitProperties)properties).determineUsername()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setUsername(arg_0));
        map.from(() -> ((RabbitProperties)properties).determinePassword()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPassword(arg_0));
        map.from(() -> ((RabbitProperties)properties).determineVirtualHost()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setVirtualHost(arg_0));
        map.from(() -> ((RabbitProperties)properties).getRequestedHeartbeat()).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setRequestedHeartbeat(arg_0));
        RabbitProperties.Ssl ssl = properties.getSsl();
        if (ssl.determineEnabled()) {
            factory.setUseSSL(true);
            map.from(() -> ((RabbitProperties.Ssl)ssl).getAlgorithm()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setSslAlgorithm(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getKeyStoreType()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStoreType(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getKeyStore()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStore(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getKeyStorePassword()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStorePassphrase(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getTrustStoreType()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStoreType(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getTrustStore()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStore(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getTrustStorePassword()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStorePassphrase(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).isValidateServerCertificate()).to(validate -> factory.setSkipServerCertificateValidation(validate == false));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getVerifyHostname()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setEnableHostnameVerification(arg_0));
        }
        map.from(() -> ((RabbitProperties)properties).getConnectionTimeout()).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setConnectionTimeout(arg_0));
        factory.afterPropertiesSet();
        return factory;
    }

    @Bean
    @Primary
    public RabbitTemplate rabbitTemplate(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter((MessageConverter)this.producerJackson2MessageConverter());
        return rabbitTemplate;
    }

    @Bean
    public Jackson2JsonMessageConverter producerJackson2MessageConverter() {
        return new Jackson2JsonMessageConverter();
    }

    @Bean
    @Primary
    public ListenerLifecycle listenerLifecycleController() {
        return new RabbitListenerLifecycle();
    }
}

