/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.rabbitmq.service;

import com.cyberway.msf.mq.config.FrameworkEventConfigProperties;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.mq.service.ConfirmListener;
import com.cyberway.msf.mq.service.FrameworkEventService;
import com.cyberway.msf.rabbitmq.service.ExchangeRoutingNameStrategy;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(name={"framework.event.type"}, havingValue="rabbitmq", matchIfMissing=true)
@ConditionalOnMissingBean(value={FrameworkEventService.class})
@ConditionalOnBean(value={RabbitTemplate.class})
public class RabbitMQFrameworkEventServiceImpl
implements FrameworkEventService {
    private final FrameworkEventConfigProperties frameworkEventConfigProperties;
    private final RabbitTemplate template;
    private InnerConfirm confirm;

    public RabbitMQFrameworkEventServiceImpl(FrameworkEventConfigProperties frameworkEventConfigProperties, RabbitTemplate template) {
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.template = template;
        this.setUpCallBack();
    }

    private void setUpCallBack() {
        this.confirm = new InnerConfirm();
        this.template.setConfirmCallback((RabbitTemplate.ConfirmCallback)this.confirm);
    }

    public void pushEvent(FrameworkEvent event) {
        this.pushEvent(event, null);
    }

    public void pushEvent(FrameworkEvent event, String route) {
        event.setSendTime(new Date());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{route})) {
            this.template.convertAndSend(this.findExchangeName(event), route, (Object)event);
        } else {
            this.template.convertAndSend(this.findExchangeName(event), this.findRoutingKey(event), (Object)event);
        }
    }

    public void pushEvent(final FrameworkEvent event, String route, final ConfirmListener callback) {
        this.setUpConfirmIfNeed();
        this.confirm.setCallback(event.getEventId(), new RabbitTemplate.ConfirmCallback(){

            public void confirm(CorrelationData correlationData, boolean ack, String cause) {
                if (ack) {
                    callback.onSuccess(event);
                } else {
                    callback.onException(event, (Throwable)new Exception(cause));
                }
            }
        });
        event.setSendTime(new Date());
        CorrelationData correlationData = new CorrelationData();
        correlationData.setId(event.getEventId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{route})) {
            this.template.convertAndSend(this.findExchangeName(event), route, (Object)event, correlationData);
        } else {
            this.template.convertAndSend(this.findExchangeName(event), this.findRoutingKey(event), (Object)event, correlationData);
        }
    }

    public void syncPushEvent(FrameworkEvent event, String route, long timeout) {
        this.setUpConfirmIfNeed();
        this.template.invoke(template -> {
            this.pushEvent(event, route);
            template.waitForConfirms(timeout);
            return true;
        });
    }

    public void syncPushEvent(FrameworkEvent event, String route) {
        this.syncPushEvent(event, route, 3000L);
    }

    private void setUpConfirmIfNeed() {
        ConnectionFactory connectionFactory = this.template.getConnectionFactory();
        if (!(connectionFactory instanceof CachingConnectionFactory)) {
            throw new UnsupportedOperationException("rabbitmq \u540c\u6b65\u53d1\u9001\u5fc5\u987b\u4f7f\u7528 CachingConnectionFactory");
        }
        CachingConnectionFactory cachingConnectionFactory = (CachingConnectionFactory)connectionFactory;
        if (!cachingConnectionFactory.isPublisherConfirms()) {
            cachingConnectionFactory.setPublisherConfirmType(CachingConnectionFactory.ConfirmType.CORRELATED);
        }
    }

    private String findExchangeName(FrameworkEvent event) {
        return ExchangeRoutingNameStrategy.findExchangeName(event.getClass(), this.frameworkEventConfigProperties);
    }

    private String findRoutingKey(FrameworkEvent event) {
        return ExchangeRoutingNameStrategy.findRoutingKey(event.getClass(), this.frameworkEventConfigProperties);
    }

    static class InnerConfirm
    implements RabbitTemplate.ConfirmCallback {
        private Map<String, RabbitTemplate.ConfirmCallback> nestCallBack = new ConcurrentHashMap<String, RabbitTemplate.ConfirmCallback>();

        InnerConfirm() {
        }

        public void setCallback(String eventId, RabbitTemplate.ConfirmCallback callback) {
            this.nestCallBack.put(eventId, callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void confirm(CorrelationData correlationData, boolean ack, String cause) {
            if (correlationData != null && correlationData.getId() != null && this.nestCallBack.get(correlationData.getId()) != null) {
                try {
                    this.nestCallBack.get(correlationData.getId()).confirm(correlationData, ack, cause);
                }
                finally {
                    this.nestCallBack.remove(correlationData.getId());
                }
            }
        }
    }
}

