/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.rabbitmq.config;

import com.cyberway.msf.interceptor.AfterConsumePostProcessor;
import com.cyberway.msf.interceptor.BeforeConsumePostProcessor;
import com.cyberway.msf.mq.annotation.FrameworkEventHandler;
import com.cyberway.msf.mq.annotation.FrameworkEventListener;
import com.cyberway.msf.mq.config.FrameworkEventConfigProperties;
import com.cyberway.msf.mq.config.FrameworkEventListenerConfigUtils;
import com.cyberway.msf.mq.config.MiddlewareType;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.rabbitmq.service.ExchangeRoutingNameStrategy;
import com.cyberway.msf.rabbitmq.util.RabbitMQUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.aopalliance.aop.Advice;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListenerConfigurer;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistrar;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RabbitmqEventAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
EnvironmentAware,
SmartInitializingSingleton {
    public static final String DEFAULT_RABBIT_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "rabbitListenerContainerFactory";
    public static final String RABBIT_EMPTY_STRING_ARGUMENTS_PROPERTY = "spring.rabbitmq.emptyStringArguments";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Set<String> emptyStringArguments = new HashSet<String>();
    private RabbitListenerEndpointRegistry endpointRegistry;
    private String defaultContainerFactoryBeanName = "rabbitListenerContainerFactory";
    private BeanFactory beanFactory;
    private final RabbitHandlerMethodFactoryAdapter messageHandlerMethodFactory = new RabbitHandlerMethodFactoryAdapter();
    private final RabbitListenerEndpointRegistrar registrar = new RabbitListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private final ConcurrentMap<Class<?>, TypeMetadata> typeCache = new ConcurrentHashMap();
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;
    private int increment;
    private Charset charset = StandardCharsets.UTF_8;
    private FrameworkEventConfigProperties frameworkEventConfigProperties;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public RabbitmqEventAnnotationBeanPostProcessor() {
        this.emptyStringArguments.add("x-dead-letter-exchange");
    }

    public void setEndpointRegistry(RabbitListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.defaultContainerFactoryBeanName = containerFactoryBeanName;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
        this.frameworkEventConfigProperties = (FrameworkEventConfigProperties)this.beanFactory.getBean(FrameworkEventConfigProperties.class);
    }

    public void setEnvironment(Environment environment) {
        String property = (String)environment.getProperty(RABBIT_EMPTY_STRING_ARGUMENTS_PROPERTY, String.class);
        if (property != null) {
            this.emptyStringArguments.addAll(StringUtils.commaDelimitedListToSet((String)property));
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map instances = ((ListableBeanFactory)this.beanFactory).getBeansOfType(RabbitListenerConfigurer.class);
            for (RabbitListenerConfigurer configurer : instances.values()) {
                configurer.configureRabbitListeners(this.registrar);
            }
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (RabbitListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.amqp.rabbit.config.internalRabbitListenerEndpointRegistry", RabbitListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.defaultContainerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.defaultContainerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
        this.typeCache.clear();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SimpleRabbitListenerContainerFactory) {
            BeforeConsumePostProcessor beforeConsumePostProcessor = (BeforeConsumePostProcessor)this.beanFactory.getBean(BeforeConsumePostProcessor.class);
            AfterConsumePostProcessor afterConsumePostProcessor = (AfterConsumePostProcessor)this.beanFactory.getBean(AfterConsumePostProcessor.class);
            SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory = (SimpleRabbitListenerContainerFactory)bean;
            rabbitListenerContainerFactory.setAfterReceivePostProcessors(new MessagePostProcessor[]{beforeConsumePostProcessor});
            Object[] advices = rabbitListenerContainerFactory.getAdviceChain();
            advices = advices != null ? (Advice[])ArrayUtils.add((Object[])advices, (Object)afterConsumePostProcessor) : new Advice[]{afterConsumePostProcessor};
            rabbitListenerContainerFactory.setAdviceChain((Advice[])advices);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        TypeMetadata metadata = this.typeCache.computeIfAbsent(targetClass, this::buildMetadata);
        for (ListenerMethod lm : metadata.listenerMethods) {
            this.processAmqpListener(lm.annotations, lm.method, bean, beanName);
        }
        if (metadata.handlerMethods.length > 0) {
            this.processMultiMethodListeners(metadata.classAnnotations, metadata.handlerMethods, bean, beanName);
        }
        return bean;
    }

    private TypeMetadata buildMetadata(Class<?> targetClass) {
        FrameworkEventListener classLevelListener = this.findListenerAnnotations(targetClass);
        boolean hasClassLevelListeners = classLevelListener != null;
        ArrayList methods = new ArrayList();
        ArrayList multiMethods = new ArrayList();
        if (hasClassLevelListeners && !FrameworkEventListenerConfigUtils.hasIgnoreEvent((List)this.frameworkEventConfigProperties.getIgnoreEvents(), (Class[])classLevelListener.value())) {
            ReflectionUtils.doWithMethods(targetClass, method -> {
                FrameworkEventHandler eventHandler = (FrameworkEventHandler)AnnotationUtils.findAnnotation((Method)method, FrameworkEventHandler.class);
                if (eventHandler != null) {
                    multiMethods.add(method);
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        if (methods.isEmpty() && multiMethods.isEmpty()) {
            return TypeMetadata.EMPTY;
        }
        return new TypeMetadata(methods.toArray(new ListenerMethod[methods.size()]), multiMethods.toArray(new Method[multiMethods.size()]), classLevelListener);
    }

    private FrameworkEventListener findListenerAnnotations(AnnotatedElement element) {
        FrameworkEventListener listener = (FrameworkEventListener)AnnotationUtils.findAnnotation((AnnotatedElement)element, FrameworkEventListener.class);
        if (listener != null && this.frameworkEventConfigProperties.getTypes().size() > 0) {
            String type = listener.type();
            if (!MiddlewareType.RABBITMQ.name().equalsIgnoreCase(type)) {
                return null;
            }
        }
        return listener;
    }

    private void processMultiMethodListeners(FrameworkEventListener classLevelListeners, Method[] multiMethods, Object bean, String beanName) {
        ArrayList<Method> checkedMethods = new ArrayList<Method>();
        Method defaultMethod = null;
        for (Method method : multiMethods) {
            Method checked = this.checkProxy(method, bean);
            FrameworkEventHandler handler = (FrameworkEventHandler)AnnotationUtils.findAnnotation((Method)method, FrameworkEventHandler.class);
            if (handler != null && handler.isDefault()) {
                Method toAssert = defaultMethod;
                Assert.state((toAssert == null ? 1 : 0) != 0, () -> "Only one @RabbitHandler can be marked 'isDefault', found: " + toAssert.toString() + " and " + method.toString());
                defaultMethod = checked;
            }
            checkedMethods.add(checked);
        }
        for (Method method : checkedMethods) {
            this.processAmqpListener(classLevelListeners, method, bean, beanName);
        }
    }

    protected void processAmqpListener(FrameworkEventListener frameworkEventListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodRabbitListenerEndpoint endpoint = new MethodRabbitListenerEndpoint();
        endpoint.setMethod(methodToUse);
        this.processListener(endpoint, frameworkEventListener, bean, methodToUse, beanName);
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@RabbitListener method '%s' found on bean target class '%s', but not found in any interface(s) for a bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    protected void processListener(MethodRabbitListenerEndpoint endpoint, FrameworkEventListener frameworkEventListener, Object bean, Object target, String beanName) {
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId());
        endpoint.setQueueNames(new String[]{this.resolveQueues(frameworkEventListener)});
        endpoint.setBeanFactory(this.beanFactory);
        RabbitListenerContainerFactory<?> factory = this.resolveContainerFactory(frameworkEventListener, target, beanName);
        this.registrar.registerEndpoint((RabbitListenerEndpoint)endpoint, factory);
    }

    @Nullable
    private RabbitListenerContainerFactory<?> resolveContainerFactory(FrameworkEventListener frameworkEventListener, Object factoryTarget, String beanName) {
        RabbitListenerContainerFactory factory = null;
        String containerFactoryBeanName = this.resolveExpressionAsString(frameworkEventListener.containerFactory(), "containerFactory");
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            this.assertBeanFactory();
            try {
                factory = (RabbitListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, RabbitListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException(this.noBeanFoundMessage(factoryTarget, beanName, containerFactoryBeanName, RabbitListenerContainerFactory.class), (Throwable)ex);
            }
        }
        return factory;
    }

    private String resolveExpressionAsString(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            return (String)resolved;
        }
        String resolvedClass = resolved != null ? resolved.getClass().toString() : "";
        throw new IllegalStateException("The [" + attribute + "] must resolve to a String. Resolved to [" + resolvedClass + "] for [" + value + "]");
    }

    private Object resolveExpression(String value) {
        String resolvedValue = this.resolve(value);
        return this.resolver.evaluate(resolvedValue, this.expressionContext);
    }

    private String resolve(String value) {
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    protected void assertBeanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
    }

    protected String noBeanFoundMessage(Object target, String listenerBeanName, String requestedBeanName, Class<?> expectedClass) {
        return "Could not register rabbit listener endpoint on [" + target + "] for bean " + listenerBeanName + ", no '" + expectedClass.getSimpleName() + "' with id '" + requestedBeanName + "' was found in the application context";
    }

    private String getEndpointId() {
        return "org.springframework.amqp.rabbit.RabbitListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    private String resolveQueues(FrameworkEventListener frameworkEventListener) {
        String queueName = frameworkEventListener.queue();
        String routingKey = frameworkEventListener.route();
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            boolean hasQueueName = StringUtils.hasText((String)queueName);
            if (hasQueueName) {
                Queue queue = new Queue(queueName);
                ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(queueName + ++this.increment, (Object)queue);
            }
            for (Class event : frameworkEventListener.value()) {
                if (!hasQueueName) {
                    queueName = RabbitMQUtils.findRoutingKey(event, this.frameworkEventConfigProperties);
                    Queue queue = new Queue(queueName);
                    ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(queueName + ++this.increment, (Object)queue);
                }
                this.declareExchangeAndBinding(event, queueName, routingKey);
            }
        }
        return queueName;
    }

    private void declareExchangeAndBinding(Class<? extends FrameworkEvent> event, String queueName, String routingKey) {
        String exchangeName = ExchangeRoutingNameStrategy.findExchangeName(event, this.frameworkEventConfigProperties);
        String exchangeType = ExchangeRoutingNameStrategy.findExchangeType(event);
        Exchange exchange = "fanout".equals(exchangeType) ? ExchangeBuilder.fanoutExchange((String)exchangeName).build() : ExchangeBuilder.topicExchange((String)exchangeName).build();
        ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(exchangeName + ++this.increment, (Object)exchange);
        this.registerBindings(event, queueName, exchangeName, routingKey, exchangeType);
    }

    private void registerBindings(Class<? extends FrameworkEvent> event, String queueName, String exchangeName, String routingKey, String exchangeType) {
        if ("fanout".equals(exchangeType)) {
            routingKey = "";
        } else if (StringUtils.isEmpty((Object)routingKey)) {
            routingKey = this.buildRoutingKey(event);
        }
        Binding actualBinding = new Binding(queueName, Binding.DestinationType.QUEUE, exchangeName, routingKey, null);
        ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(exchangeName + "." + queueName + ++this.increment, (Object)actualBinding);
    }

    private String buildRoutingKey(Class<? extends FrameworkEvent> event) {
        return ExchangeRoutingNameStrategy.findRoutingKey(event, this.frameworkEventConfigProperties);
    }

    private static class BytesToStringConverter
    implements Converter<byte[], String> {
        private final Charset charset;

        BytesToStringConverter(Charset charset) {
            this.charset = charset;
        }

        public String convert(byte[] source) {
            return new String(source, this.charset);
        }
    }

    private static class ListenerMethod {
        final Method method;
        final FrameworkEventListener annotations;

        ListenerMethod(Method method, FrameworkEventListener annotations) {
            this.method = method;
            this.annotations = annotations;
        }
    }

    private static class TypeMetadata {
        final ListenerMethod[] listenerMethods;
        final Method[] handlerMethods;
        final FrameworkEventListener classAnnotations;
        static final TypeMetadata EMPTY = new TypeMetadata();

        private TypeMetadata() {
            this.listenerMethods = new ListenerMethod[0];
            this.handlerMethods = new Method[0];
            this.classAnnotations = null;
        }

        TypeMetadata(ListenerMethod[] methods, Method[] multiMethods, FrameworkEventListener classLevelListeners) {
            this.listenerMethods = methods;
            this.handlerMethods = multiMethods;
            this.classAnnotations = classLevelListeners;
        }
    }

    private class RabbitHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory factory;

        RabbitHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory rabbitHandlerMethodFactory1) {
            this.factory = rabbitHandlerMethodFactory1;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getFactory() {
            if (this.factory == null) {
                this.factory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.factory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            defaultFactory.setBeanFactory(RabbitmqEventAnnotationBeanPostProcessor.this.beanFactory);
            DefaultConversionService conversionService = new DefaultConversionService();
            conversionService.addConverter((Converter)new BytesToStringConverter(RabbitmqEventAnnotationBeanPostProcessor.this.charset));
            defaultFactory.setConversionService((ConversionService)conversionService);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

