/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.rabbitmq.service;

import com.cyberway.msf.mq.service.ListenerLifecycle;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RabbitListenerLifecycle
implements ListenerLifecycle,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RabbitListenerLifecycle.class);
    private ApplicationContext applicationContext;

    public void stop() {
        Map registryMap = this.applicationContext.getBeansOfType(RabbitListenerEndpointRegistry.class);
        for (RabbitListenerEndpointRegistry registry : registryMap.values()) {
            if (!registry.isRunning()) continue;
            registry.stop();
        }
        logger.info(" listener stop ");
    }

    public void restart() {
        Map registryMap = this.applicationContext.getBeansOfType(RabbitListenerEndpointRegistry.class);
        for (RabbitListenerEndpointRegistry registry : registryMap.values()) {
            if (registry.isRunning()) continue;
            registry.start();
        }
        logger.info(" listener start ");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

