/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.rabbitmq.service;

import com.cyberway.msf.interceptor.AfterPublishPostProcessor;
import com.cyberway.msf.mq.config.FrameworkEventConfigProperties;
import com.cyberway.msf.mq.config.FrameworkEventListenerConfigUtils;
import com.cyberway.msf.mq.model.FrameworkEvent;
import com.cyberway.msf.mq.service.ConfirmListener;
import com.cyberway.msf.mq.service.FrameworkEventService;
import com.cyberway.msf.rabbitmq.util.RabbitMQUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(name={"framework.event.type"}, havingValue="rabbitmq", matchIfMissing=true)
@ConditionalOnMissingBean(value={FrameworkEventService.class})
@ConditionalOnBean(value={RabbitTemplate.class})
public class RabbitMQFrameworkEventServiceImpl
implements FrameworkEventService {
    private final FrameworkEventConfigProperties frameworkEventConfigProperties;
    private final RabbitTemplate template;
    private InnerConfirm confirm;
    private final AfterPublishPostProcessor afterPublishPostProcessor;

    public RabbitMQFrameworkEventServiceImpl(FrameworkEventConfigProperties frameworkEventConfigProperties, RabbitTemplate template, AfterPublishPostProcessor afterPublishPostProcessor) {
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.template = template;
        this.afterPublishPostProcessor = afterPublishPostProcessor;
        this.setUpCallBack();
    }

    private void setUpCallBack() {
        this.confirm = new InnerConfirm();
        this.template.setConfirmCallback((RabbitTemplate.ConfirmCallback)this.confirm);
    }

    public void pushEvent(FrameworkEvent event) {
        this.pushEvent(event, null);
    }

    public void pushEvent(FrameworkEvent event, String route) {
        if (FrameworkEventListenerConfigUtils.hasIgnoreEvent((List)this.frameworkEventConfigProperties.getIgnoreEvents(), (FrameworkEvent)event)) {
            return;
        }
        event.setSendTime(new Date());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{route})) {
            this.template.convertAndSend(RabbitMQUtils.findExchangeName(event, this.frameworkEventConfigProperties), route, (Object)event);
        } else {
            this.template.convertAndSend(RabbitMQUtils.findExchangeName(event, this.frameworkEventConfigProperties), RabbitMQUtils.findRoutingKey(event, this.frameworkEventConfigProperties), (Object)event);
        }
        this.afterPublishPostProcessor.postProcessMessage(event);
    }

    public void pushEvent(FrameworkEvent event, String route, ConfirmListener callback) {
        if (FrameworkEventListenerConfigUtils.hasIgnoreEvent((List)this.frameworkEventConfigProperties.getIgnoreEvents(), (FrameworkEvent)event)) {
            return;
        }
        this.setUpConfirmIfNeed();
        this.confirm.setCallback(event.getEventId(), (correlationData, ack, cause) -> {
            if (ack) {
                callback.onSuccess(event);
            } else {
                callback.onException(event, (Throwable)new Exception(cause));
            }
            this.afterPublishPostProcessor.postProcessMessage(event);
        });
        event.setSendTime(new Date());
        CorrelationData correlationData2 = new CorrelationData();
        correlationData2.setId(event.getEventId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{route})) {
            this.template.convertAndSend(RabbitMQUtils.findExchangeName(event, this.frameworkEventConfigProperties), route, (Object)event, correlationData2);
        } else {
            this.template.convertAndSend(RabbitMQUtils.findExchangeName(event, this.frameworkEventConfigProperties), RabbitMQUtils.findRoutingKey(event, this.frameworkEventConfigProperties), (Object)event, correlationData2);
        }
    }

    public void syncPushEvent(FrameworkEvent event, String route, long timeout) {
        if (FrameworkEventListenerConfigUtils.hasIgnoreEvent((List)this.frameworkEventConfigProperties.getIgnoreEvents(), (FrameworkEvent)event)) {
            return;
        }
        this.setUpConfirmIfNeed();
        this.template.invoke(template -> {
            this.pushEvent(event, route);
            template.waitForConfirms(timeout);
            return true;
        });
    }

    public void syncPushEvent(FrameworkEvent event, String route) {
        this.syncPushEvent(event, route, 3000L);
    }

    private void setUpConfirmIfNeed() {
        ConnectionFactory connectionFactory = this.template.getConnectionFactory();
        if (!(connectionFactory instanceof CachingConnectionFactory)) {
            throw new UnsupportedOperationException("rabbitmq \u540c\u6b65\u53d1\u9001\u5fc5\u987b\u4f7f\u7528 CachingConnectionFactory");
        }
        CachingConnectionFactory cachingConnectionFactory = (CachingConnectionFactory)connectionFactory;
        if (!cachingConnectionFactory.isPublisherConfirms()) {
            cachingConnectionFactory.setPublisherConfirmType(CachingConnectionFactory.ConfirmType.CORRELATED);
        }
    }

    static class InnerConfirm
    implements RabbitTemplate.ConfirmCallback {
        private Map<String, RabbitTemplate.ConfirmCallback> nestCallBack = new ConcurrentHashMap<String, RabbitTemplate.ConfirmCallback>();

        InnerConfirm() {
        }

        public void setCallback(String eventId, RabbitTemplate.ConfirmCallback callback) {
            this.nestCallBack.put(eventId, callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void confirm(CorrelationData correlationData, boolean ack, String cause) {
            if (correlationData != null && correlationData.getId() != null && this.nestCallBack.get(correlationData.getId()) != null) {
                try {
                    this.nestCallBack.get(correlationData.getId()).confirm(correlationData, ack, cause);
                }
                finally {
                    this.nestCallBack.remove(correlationData.getId());
                }
            }
        }
    }
}

