/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.ms.utils;

import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.ms.model.message.dto.MessageDto;
import com.cyberway.msf.ms.model.mq.dto.MqDto;
import com.cyberway.msf.ms.utils.MqUtil;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class MessageUtil
extends MqUtil {
    private static MessageUtil messageUtil;

    @PostConstruct
    public void init() {
        messageUtil = this;
    }

    public static void removeMessage(String messageId) {
        MessageDto message = new MessageDto();
        message.setMessageId(messageId);
        messageUtil.remove(message);
    }

    public static void sendTemplateMessage(String templateCode, Map<String, Object> params, String toUser, String toUserName) {
        MessageDto message = new MessageDto();
        message.setTemplateCode(templateCode);
        message.setParamsMap(params);
        message.setReceiverId(toUser);
        message.setReceiver(toUserName);
        UserInfo loggedInUser = UserUtils.getLoggedInUser();
        if (null != loggedInUser) {
            message.setSenderId((String)((Object)loggedInUser.getId()));
            message.setSender(loggedInUser.getFullName());
        }
        messageUtil.send(message);
    }

    private void send(MessageDto messageDto) {
        this.sendMessage(this.getMqDto(messageDto));
    }

    private void remove(MessageDto messageDto) {
        this.sendMessage(this.getMqDto(messageDto, "topic.common.messages.delete"));
    }

    protected MqDto getMqDto(MessageDto dto) {
        MqDto mq = new MqDto();
        mq.setExchange("exchange.common.messages");
        mq.setRoutingKey("topic.common.messages");
        mq.setBody(dto);
        return mq;
    }

    protected MqDto getMqDto(MessageDto dto, String routingKey) {
        MqDto mq = new MqDto();
        mq.setExchange("exchange.common.messages");
        mq.setRoutingKey(routingKey);
        mq.setBody(dto);
        return mq;
    }
}

