/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.org.dto;

import com.cyberway.msf.org.model.department.DepartmentType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum ResourceTreeParams {
    COMPANY("company", DepartmentType.companyValues()),
    DEPARTMENT("department", DepartmentType.departmentValues()),
    COMMUNITY("community"),
    ZONE("zone"),
    BUILDING("building"),
    BUILDINGUNIT("buildingUnit"),
    HOUSE("house"),
    CUSTOMER("customer");

    private String value;
    private List<Integer> showTypeList = new ArrayList<Integer>();

    private ResourceTreeParams(String value) {
        this.value = value;
    }

    private ResourceTreeParams(String value, List<Integer> showTypeList) {
        this.value = value;
        this.showTypeList = showTypeList;
    }

    public String getValue() {
        return this.value;
    }

    public List<Integer> getShowTypeList() {
        return this.showTypeList;
    }

    public static boolean contains(String value) {
        for (ResourceTreeParams resourceTreeParams : ResourceTreeParams.values()) {
            if (!StringUtils.equals((CharSequence)resourceTreeParams.value, (CharSequence)value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isShow(String showType, Integer type) {
        if (StringUtils.isEmpty((CharSequence)showType)) {
            return false;
        }
        for (ResourceTreeParams resourceTreeParams : ResourceTreeParams.values()) {
            if (!StringUtils.equals((CharSequence)resourceTreeParams.value, (CharSequence)showType) || !resourceTreeParams.showTypeList.contains(type)) continue;
            return true;
        }
        return false;
    }
}

