/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.org.client;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.org.dto.DepartmentInitDto;
import com.cyberway.msf.org.model.department.Department;
import com.cyberway.msf.org.vo.department.DepartmentVo;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(contextId="DepartmentClient", value="${feign.org:cyberway-msf-org}", path="/api/department")
public interface DepartmentClient {
    @GetMapping(value={"/getByCode"})
    public ApiResponseResult<Department> getDepartmentByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/{id}"})
    public ApiResponseResult<DepartmentVo> getDepartment(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/getManagerUserId"})
    public ApiResponseResult<Long> getManagerUserIdByDepartmentId(@RequestParam(value="departmentId") Long var1);

    @GetMapping(value={"/getManagerUserIdByUserId"})
    public ApiResponseResult<Long> getManagerUserIdByUserId(@RequestParam(value="userId") Long var1);

    @PostMapping(value={"/listByIds"})
    public ApiResponseResult<List<DepartmentVo>> listDepartmentsByIds(@RequestBody List<Long> var1);

    @GetMapping(value={"/getHeadCompany"})
    public ApiResponseResult<Department> getHeadCompany();

    @GetMapping(value={"/updateDepartmentName"})
    public ApiResponseResult<Integer> updateDepartmentName(@RequestParam(value="name") String var1, @RequestParam(value="tenantId") Long var2);

    @PostMapping(value={"/initInsert"})
    public ApiResponseResult<Boolean> initInsert(@RequestBody DepartmentInitDto var1);

    @GetMapping(value={"/findSubDepartmentsAndSelf"})
    public ApiResponseResult<List<Department>> findSubDepartmentsAndSelfByCompanyId(@RequestParam(value="companyId") Long var1);

    @PostMapping(value={"/findByDepartmentType"})
    public ApiResponseResult<List<Map<String, Object>>> findByDepartmentType(@RequestParam(value="value") Integer var1, @RequestParam(value="businessType") String var2);

    @PostMapping(value={"/getByDepartmentId"})
    public ApiResponseResult<Department> getByDepartmentId(@RequestParam(value="id") Long var1);

    @PostMapping(value={"/list"})
    public ApiResponseResult<PageDataModel<DepartmentVo>> listDepartments(@RequestParam(value="departmentId") Long var1, @RequestParam(value="name") String var2, @RequestParam(value="departmentType") Integer var3, @RequestParam(value="codeName") String var4, @RequestBody PageModel var5);
}

