/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.payment.client;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.payment.dto.WithdrawOrderDto;
import com.cyberway.msf.payment.model.Payment;
import com.cyberway.msf.payment.model.UnifiedOrderVo;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(contextId="PaymentClient", value="${feign.payment:cyberway-msf-payment}", path="/api")
public interface PaymentClient {
    @PostMapping(value={"/paymentmethod/unifiedOrder"})
    public ApiResponseResult<Long> unifiedOrder(@RequestBody @Valid UnifiedOrderVo var1);

    @PostMapping(value={"/withdraw/withdrawOrder"})
    public ApiResponseResult withdrawOrder(@RequestBody @Valid WithdrawOrderDto var1);

    @PostMapping(value={"/paymentmethod/unifiedOrderPayment"})
    public ApiResponseResult<Payment> unifiedOrderPayment(@RequestBody @Valid UnifiedOrderVo var1);

    @GetMapping(value={"/payment/{id}"})
    public ApiResponseResult<Payment> selectById(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/payment/getPayment/findBySn"})
    public ApiResponseResult<Payment> findBySn(@RequestParam(value="sn") String var1);

    @GetMapping(value={"/payment/getPayment/findByOrderSn"})
    public ApiResponseResult<Payment> findByOrderSn(@RequestParam(value="orderSn") String var1);

    @PutMapping(value={"/payment/{id}"})
    public ApiResponseResult<Integer> update(@PathVariable(value="id") Long var1, @RequestBody Payment var2);
}

