/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.scheduling.config;

import com.cyberway.msf.commons.base.util.UserUtils;
import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.org.vo.organization.OrganizationCacheVO;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JobOrgHandlerAspect {
    private final Logger logger = LoggerFactory.getLogger(JobOrgHandlerAspect.class);
    @Autowired
    private RedisUtils redisUtils;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();

    public JobOrgHandlerAspect() {
        this.threadPoolTaskExecutor.setCorePoolSize(Runtime.getRuntime().availableProcessors() * 2);
        this.threadPoolTaskExecutor.initialize();
    }

    @Around(value="@annotation(com.cyberway.msf.scheduling.config.JobOrgSupport)")
    public Object doJobWithOrgHandle(ProceedingJoinPoint joinPoint) {
        List orgList = UserUtils.getAllOrgList();
        if (orgList.isEmpty()) {
            return null;
        }
        CountDownLatch latch = new CountDownLatch(orgList.size());
        for (OrganizationCacheVO org : orgList) {
            this.threadPoolTaskExecutor.execute(() -> {
                try {
                    UserInfo user = UserUtils.getAnonymousUser((Long)org.getTenantId(), (Long)org.getId(), (String)org.getCodeName());
                    UserUtils.setLocalUserInfo((UserInfo)user, (boolean)false);
                    joinPoint.proceed();
                }
                catch (Throwable ex) {
                    this.logger.warn(ex.getMessage(), ex);
                }
                finally {
                    UserUtils.resetLocalUserInfo();
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

