/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.scheduling.config;

import com.cyberway.msf.commons.cache.RedisUtils;
import com.cyberway.msf.scheduling.config.JobOrgHandlerAspect;
import com.cyberway.msf.scheduling.config.SchedulingProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SchedulingProperties.class})
public class SchedulingConfig {
    @Autowired
    private SchedulingProperties schedulingProperties;

    @Bean
    @ConditionalOnMissingBean(value={XxlJobSpringExecutor.class})
    public XxlJobSpringExecutor xxlJobExecutor() {
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(this.schedulingProperties.getAdminAddresses());
        xxlJobSpringExecutor.setAppname(this.schedulingProperties.getExecutor().getAppname());
        xxlJobSpringExecutor.setIp(this.schedulingProperties.getExecutor().getIp());
        xxlJobSpringExecutor.setPort(Optional.ofNullable(this.schedulingProperties.getExecutor().getPort()).orElse(0).intValue());
        xxlJobSpringExecutor.setAccessToken(this.schedulingProperties.getExecutor().getAccessToken());
        xxlJobSpringExecutor.setLogPath(this.schedulingProperties.getExecutor().getLogpath());
        xxlJobSpringExecutor.setLogRetentionDays(Optional.ofNullable(this.schedulingProperties.getExecutor().getLogretentiondays()).orElse(30).intValue());
        return xxlJobSpringExecutor;
    }

    @Bean
    @ConditionalOnMissingBean(value={JobOrgHandlerAspect.class})
    @ConditionalOnBean(value={RedisUtils.class})
    public JobOrgHandlerAspect jobOrgHandlerAspect() {
        return new JobOrgHandlerAspect();
    }
}

