/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.user.client;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.user.UserInfo;
import com.cyberway.msf.user.model.role.RoleVo;
import com.cyberway.msf.user.model.user.User;
import com.cyberway.msf.user.model.user.UserType;
import com.cyberway.msf.user.model.user.dto.UserDto;
import com.cyberway.msf.user.model.user.dto.UserLoginDto;
import com.cyberway.msf.user.model.user.vo.UserVo;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(contextId="UserClient", value="${feign.user:cyberway-msf-user}")
public interface UserClient {
    @PostMapping(value={"/api/admin/login"})
    public ApiResponseResult<UserInfo> login(@RequestBody UserLoginDto var1);

    @PostMapping(value={"/api/user/insertUserType"})
    public ApiResponseResult insertUserType(@RequestParam(value="typeId") Long var1, @RequestParam(value="businessType") String var2, @RequestBody @Valid UserDto var3);

    @GetMapping(value={"/api/user/relateWithUser"})
    public ApiResponseResult relateWithUser(@RequestParam(value="userId") Long var1, @RequestParam(value="businessType") String var2, @RequestParam(value="typeId") Long var3);

    @GetMapping(value={"/api/user/getUserTypeId"})
    public ApiResponseResult<Long> getUserTypeId(@RequestParam(value="userId") Long var1, @RequestParam(value="businessType") String var2);

    @GetMapping(value={"/api/user/{id}"})
    public ApiResponseResult<UserVo> getUser(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/user/getRelatedUserId"})
    public ApiResponseResult<Long> getRelatedUserId(@RequestParam(value="businessType") String var1, @RequestParam(value="typeId") Long var2);

    @PostMapping(value={"/api/user/getRelatedUserIds"})
    public ApiResponseResult<List<Long>> getRelatedUserIds(@RequestParam(value="businessType") String var1, @RequestBody List<Long> var2);

    @PostMapping(value={"/api/user/disassociateWithUser"})
    public ApiResponseResult disassociateWithUser(@RequestParam(value="businessType") String var1, @RequestBody List<Long> var2);

    @GetMapping(value={"/api/user/getRelatedUser"})
    public ApiResponseResult<UserVo> getRelatedUser(@RequestParam(value="businessType") String var1, @RequestParam(value="typeId") Long var2);

    @PostMapping(value={"/api/user"})
    public ApiResponseResult insertUser(@RequestBody UserDto var1);

    @GetMapping(value={"/api/user/initTenantUser"})
    public ApiResponseResult initTenantUser(@RequestParam(value="tenantCode") String var1, @RequestParam(value="tenantId") Long var2, @RequestParam(value="orgId") Long var3, @RequestParam(value="companyId") Long var4);

    @ApiOperation(value="\u4e34\u65f6\u79df\u6237\u7ba1\u7406\u5458\u89e3\u9664\u51bb\u7ed3")
    @PostMapping(value={"/api/user/unfreezeTenantTempUser"})
    public ApiResponseResult unfreezeTenantTempUser(@RequestParam(value="tenantCode") String var1, @RequestParam(value="tenantId") Long var2, @RequestParam(value="tenantTempId") Long var3, @RequestParam(value="orgId") Long var4, @RequestParam(value="companyId") Long var5, @RequestBody List<Long> var6);

    @ApiOperation(value="\u66f4\u65b0\u79df\u6237\u7ba1\u7406\u5458\u6743\u9650")
    @PostMapping(value={"/api/user/updateTenantPrivilege"})
    public ApiResponseResult updateTenantPrivilege(@RequestParam(value="tenantId") Long var1, @RequestBody List<Long> var2);

    @PostMapping(value={"/api/user/initTenantTempUser"})
    public ApiResponseResult initTenantTempUser(@RequestParam(value="tenantTempId") Long var1, @RequestBody UserDto var2);

    @GetMapping(value={"/api/user/initOrgUser"})
    public ApiResponseResult initOrgUser(@RequestParam(value="codeName") String var1, @RequestParam(value="tenantId") Long var2, @RequestParam(value="orgId") Long var3, @RequestParam(value="companyId") Long var4, @RequestParam(value="orgCode") String var5);

    @PostMapping(value={"/api/user/replaceRelateUserType"})
    public ApiResponseResult replaceRelateUserType(@RequestBody List<Long> var1, @RequestParam(value="businessType") String var2, @RequestParam(value="typeId") Long var3);

    @GetMapping(value={"/api/user/listRelatedUser"})
    public ApiResponseResult<List<UserVo>> listRelatedUser(@RequestParam(value="businessType") String var1, @RequestParam(value="typeId") Long var2);

    @GetMapping(value={"/api/user/tenantAdmin/{tenantId}"})
    public ApiResponseResult<UserVo> getTenantAdminUser(@PathVariable(value="tenantId") Long var1);

    @PostMapping(value={"/api/user/updateTenantCode"})
    public ApiResponseResult updateTenantCode(@RequestParam(value="tenantCode") String var1, @RequestParam(value="tenantId") Long var2);

    @PostMapping(value={"/api/user/insertOrEditUserType"})
    public ApiResponseResult insertOrEditUserType(@RequestParam(value="typeId") Long var1, @RequestParam(value="businessType") String var2, @RequestBody @Valid UserDto var3);

    @PostMapping(value={"/api/user/batchInsertUserType"})
    public ApiResponseResult batchInsertUserType(@RequestBody List<UserDto> var1);

    @PostMapping(value={"/api/user/checkBusinessType"})
    public ApiResponseResult<UserType> checkBusinessType(@RequestParam(value="loginName") String var1, @RequestParam(value="businessType") String var2);

    @PostMapping(value={"/api/user/checkBusinessTypeByEmployee"})
    public ApiResponseResult<Integer> checkBusinessTypeByEmployee(@RequestParam(value="loginName") String var1, @RequestParam(value="businessType") String var2);

    @GetMapping(value={"/api/user/getNameById"})
    public ApiResponseResult<String> getNameById(@RequestParam(value="id") Long var1);

    @PostMapping(value={"/api/user/getNamesByIds"})
    public ApiResponseResult<Map<Long, String>> getNamesByIds(@RequestBody List<Long> var1);

    @PostMapping(value={"/api/admin/switchLoginDuty"})
    public ApiResponseResult<Boolean> switchLoginDuty(@RequestParam(value="departmentDutyId") Long var1);

    @PostMapping(value={"/api/user/list"})
    public ApiResponseResult<PageDataModel<UserVo>> listUsers(@RequestParam(value="fullName", required=false) String var1, @RequestParam(value="loginName", required=false) String var2, @RequestParam(value="mobileTel", required=false) String var3, @RequestParam(value="email", required=false) String var4, @RequestParam(value="businessType", required=false) String var5, @RequestBody(required=false) PageModel var6);

    @GetMapping(value={"/api/user/user/getUserById"})
    public ApiResponseResult<User> getUserById(@RequestParam(value="id") Long var1);

    @PutMapping(value={"/api/user/{id}"})
    public ApiResponseResult updateUser(@PathVariable(value="id") Long var1, @RequestBody UserDto var2);

    @PostMapping(value={"/api/user/getUsersByRoleCodeCompanyId"})
    public ApiResponseResult<List<UserVo>> getUsersByRoleCodeCompanyId(@RequestParam(value="roleCode", required=true) String var1, @RequestParam(value="companyId", required=false) Long var2);

    @RequestMapping(value={"/api/user/userRoles/{userId}"}, method={RequestMethod.GET})
    public ApiResponseResult<List<RoleVo>> getUserRoles(@PathVariable(value="userId") Long var1);

    @RequestMapping(value={"/api/user/getUserByEmployeeId"}, method={RequestMethod.POST})
    public ApiResponseResult<UserVo> getUserByEmployeeId(@RequestParam(value="employeeId") Long var1);
}

