/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.workflow.client;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.cyberway.msf.workflow.model.Task;
import com.cyberway.msf.workflow.param.TaskAssigneeInfoQueryParam;
import com.cyberway.msf.workflow.param.TaskClaimParam;
import com.cyberway.msf.workflow.param.TaskCompleteParam;
import com.cyberway.msf.workflow.param.TaskDelegateParam;
import com.cyberway.msf.workflow.param.TaskFinParam;
import com.cyberway.msf.workflow.param.TaskFindTodoForUserParam;
import com.cyberway.msf.workflow.param.TaskJumpParam;
import com.cyberway.msf.workflow.param.TaskListParam;
import com.cyberway.msf.workflow.param.TaskQueryParam;
import com.cyberway.msf.workflow.param.TaskRollbackToParam;
import com.cyberway.msf.workflow.param.TaskUserChangeParam;
import com.cyberway.msf.workflow.vo.TaskAssigneeInfo;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${feign.workflow:cyberway-msf-workflow}")
public interface TaskClient {
    @PostMapping(value={"/api/task/{taskId}/claim"})
    public ApiResponseResult<Boolean> claim(@PathVariable(value="taskId") String var1, @RequestBody TaskClaimParam var2);

    @PostMapping(value={"/api/task/{taskId}/unclaim"})
    public ApiResponseResult<Boolean> unclaim(@PathVariable(value="taskId") String var1);

    @PostMapping(value={"/api/task/{taskId}/complete"})
    public ApiResponseResult<Boolean> complete(@PathVariable(value="taskId") String var1, @RequestBody TaskCompleteParam var2);

    @PostMapping(value={"/api/task/{taskId}/updateVariables"})
    public ApiResponseResult<Boolean> updateVariables(@PathVariable(value="taskId") String var1, @RequestBody Map<String, Object> var2);

    @PostMapping(value={"/api/task/{taskId}/updateVariablesLocal"})
    public ApiResponseResult<Boolean> updateVariablesLocal(@PathVariable(value="taskId") String var1, @RequestBody Map<String, Object> var2);

    @PostMapping(value={"/api/task/{taskId}/removeVariables"})
    public ApiResponseResult<Boolean> removeVariables(@PathVariable(value="taskId") String var1, @RequestBody List<String> var2);

    @PostMapping(value={"/api/task/{taskId}/removeVariablesLocal"})
    public ApiResponseResult<Boolean> removeVariablesLocal(@PathVariable(value="taskId") String var1, @RequestBody List<String> var2);

    @PostMapping(value={"/api/task/{taskId}/changeAssignee"})
    public ApiResponseResult<Boolean> changeAssignee(@PathVariable(value="taskId") String var1, @RequestBody TaskUserChangeParam var2);

    @PostMapping(value={"/api/task/{taskId}/changeOwner"})
    public ApiResponseResult<Boolean> changeOwner(@PathVariable(value="taskId") String var1, @RequestBody TaskUserChangeParam var2);

    @PostMapping(value={"/api/task/{taskId}/delegate"})
    public ApiResponseResult<Boolean> delegate(@PathVariable(value="taskId") String var1, @RequestBody TaskDelegateParam var2);

    @PostMapping(value={"/api/task/{taskId}/jump"})
    public ApiResponseResult<Boolean> jump(@PathVariable(value="taskId") String var1, @RequestBody TaskJumpParam var2);

    @PostMapping(value={"/api/task/query"})
    public ApiResponseResult<PageDataModel<Task>> query(@RequestBody TaskQueryParam var1);

    @PostMapping(value={"/api/task/list"})
    public ApiResponseResult<PageDataModel<Task>> list(@RequestBody TaskListParam var1);

    @PostMapping(value={"/api/task/todo"})
    public ApiResponseResult<PageDataModel<Task>> todo(@RequestBody TaskFindTodoForUserParam var1);

    @GetMapping(value={"/api/task/{id}"})
    public ApiResponseResult<Task> detail(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/task/queryTaskAssigneeInfo"})
    public ApiResponseResult<List<TaskAssigneeInfo>> queryTaskAssigneeInfo(@RequestBody TaskAssigneeInfoQueryParam var1);

    @PostMapping(value={"/api/task/{taskId}/rejectToStart"})
    public ApiResponseResult<Boolean> rejectToStart(@PathVariable(value="taskId") String var1, @RequestBody TaskFinParam var2);

    @PostMapping(value={"/api/task/{taskId}/rollback"})
    public ApiResponseResult<Boolean> rollback(@PathVariable(value="taskId") String var1, @RequestBody TaskFinParam var2);

    @PostMapping(value={"/api/task/{taskId}/rollbackTo"})
    public ApiResponseResult<Boolean> rollbackTo(@PathVariable(value="taskId") String var1, @RequestBody TaskRollbackToParam var2);

    @PostMapping(value={"/api/task/{id}/addParallelTaskInstance"})
    public ApiResponseResult<Boolean> addParallelTaskInstance(@PathVariable(value="id") String var1, @RequestParam(value="newTaskAssignee") Long var2);

    @PostMapping(value={"/api/task/{id}/rollbackAbleNode"})
    public ApiResponseResult<Map<String, String>> rollbackAbleNode(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/task/{id}/jumpAbleNode"})
    public ApiResponseResult<Map<String, String>> jumpAbleNode(@PathVariable(value="id") String var1);
}

