/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.workflow.util;

import com.cyberway.msf.commons.model.base.EntityImpl;
import com.cyberway.msf.commons.model.util.LongUtils;
import com.cyberway.msf.workflow.param.ProcessInstanceStartParam;
import com.cyberway.msf.workflow.param.TaskCompleteParam;
import com.cyberway.msf.workflow.param.TaskFinParam;
import com.cyberway.msf.workflow.param.TaskRollbackToParam;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;

public class WorkflowUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private WorkflowUtils() {
    }

    public static ProcessInstanceStartParam initProcessInstanceStartParam(EntityImpl<?> formEntity, String businessNo) throws JsonProcessingException {
        ProcessInstanceStartParam processInstanceStartParam = new ProcessInstanceStartParam();
        processInstanceStartParam.setBusinessKey(formEntity.getId() instanceof Long ? LongUtils.longToString((Long)((Long)formEntity.getId())) : formEntity.getId().toString());
        processInstanceStartParam.setBusinessNo(businessNo);
        HashMap<String, Object> variables = new HashMap<String, Object>(16);
        variables.put("varEntity", OBJECT_MAPPER.writeValueAsString(formEntity));
        variables.put("varEntityType", formEntity.getClass().getName());
        processInstanceStartParam.setVariables(variables);
        return processInstanceStartParam;
    }

    public static TaskCompleteParam initTaskCompleteParam(EntityImpl<?> formEntity, String remark, String lastModified, String createdDate, String receiveFormTimeOut, String voteFormTimeOut) throws JsonProcessingException {
        return WorkflowUtils.initTaskCompleteParam(formEntity, remark, lastModified, formEntity.getId() instanceof Long ? LongUtils.longToString((Long)((Long)formEntity.getId())) : formEntity.getId().toString(), createdDate, receiveFormTimeOut, voteFormTimeOut);
    }

    public static TaskCompleteParam initTaskCompleteParam(EntityImpl<?> formEntity, String remark, String lastModified, String businessId, String createdDate, String receiveFormTimeOut, String voteFormTimeOut) throws JsonProcessingException {
        TaskCompleteParam taskCompleteParam = new TaskCompleteParam();
        HashMap<String, Object> variables = new HashMap<String, Object>(16);
        variables.put("varEntity", OBJECT_MAPPER.writeValueAsString(formEntity));
        taskCompleteParam.setVariables(variables);
        taskCompleteParam.setRemark(remark);
        taskCompleteParam.setBusinessId(businessId);
        taskCompleteParam.setLastModified(lastModified);
        taskCompleteParam.setCreatedDate(createdDate);
        taskCompleteParam.setReceiveFormTimeOut(receiveFormTimeOut);
        taskCompleteParam.setVoteFormTimeOut(voteFormTimeOut);
        return taskCompleteParam;
    }

    public static TaskFinParam initTaskFinParam(EntityImpl<?> formEntity, String remark) throws JsonProcessingException {
        TaskFinParam taskFinParam = new TaskFinParam();
        HashMap<String, Object> variables = new HashMap<String, Object>(16);
        variables.put("varEntity", OBJECT_MAPPER.writeValueAsString(formEntity));
        taskFinParam.setVariables(variables);
        taskFinParam.setRemark(remark);
        return taskFinParam;
    }

    public static TaskRollbackToParam initTaskRollbackToParam(String targetNodeKey, EntityImpl<?> formEntity, String remark) throws JsonProcessingException {
        TaskRollbackToParam taskRollbackToParam = new TaskRollbackToParam();
        HashMap<String, Object> variables = new HashMap<String, Object>(16);
        variables.put("varEntity", OBJECT_MAPPER.writeValueAsString(formEntity));
        taskRollbackToParam.setVariables(variables);
        taskRollbackToParam.setRemark(remark);
        taskRollbackToParam.setTargetNodeKey(targetNodeKey);
        return taskRollbackToParam;
    }
}

