/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.information.vo.news;

import com.cyberway.information.vo.news.NewsProductStatisticsItemVO;
import com.cyberway.information.vo.news.NewsProductStatisticsVO;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NewsProductStatisticsTotalVO {
    @ApiModelProperty(value="\u65b0\u5143\u7d20\u4fe1\u606f")
    private NewsProductStatisticsItemVO elementInfo;
    @ApiModelProperty(value="\u4ea7\u54c1\u6982\u5ff5\u4fe1\u606f")
    private NewsProductStatisticsItemVO conceptInfo;
    @ApiModelProperty(value="\u901a\u8fc7\u521d\u7b5b\u6982\u5ff5\u4fe1\u606f")
    private NewsProductStatisticsItemVO screenConceptInfo;
    @ApiModelProperty(value="\u901a\u8fc7\u53ef\u884c\u6027\u8bc4\u4f30\u6982\u5ff5\u4fe1\u606f")
    private NewsProductStatisticsItemVO passConceptInfo;
    @ApiModelProperty(value="\u63d0\u6848\u4fe1\u606f")
    private NewsProductStatisticsItemVO proposalInfo;
    @ApiModelProperty(value="\u901a\u8fc7\u8bc4\u5ba1\u63d0\u6848\u4fe1\u606f")
    private NewsProductStatisticsItemVO passProposalInfo;
    @ApiModelProperty(value="\u65b0\u5143\u7d20\u8f6c\u5316\u7387")
    private BigDecimal elementConversionRate;
    @ApiModelProperty(value="\u4ea7\u54c1\u6982\u5ff5\u901a\u8fc7\u521d\u7b5b\u7387")
    private BigDecimal conceptScreenRate;
    @ApiModelProperty(value="\u4ea7\u54c1\u6982\u5ff5\u901a\u8fc7\u7387")
    private BigDecimal conceptPassRate;
    @ApiModelProperty(value="\u4ea7\u54c1\u63d0\u6848\u901a\u8fc7\u7387")
    private BigDecimal proposalPassRate;
    @ApiModelProperty(value="\u90e8\u95e8\u7edf\u8ba1\u4fe1\u606f\u5217\u8868")
    private List<NewsProductStatisticsVO> newsProductStatisticsList;

    public NewsProductStatisticsItemVO getElementInfo() {
        this.elementInfo = this.getNewsProductStatisticsItemVO(this.newsProductStatisticsList.stream().map(NewsProductStatisticsVO::getElementInfo));
        return this.elementInfo;
    }

    public NewsProductStatisticsItemVO getConceptInfo() {
        this.conceptInfo = this.getNewsProductStatisticsItemVO(this.newsProductStatisticsList.stream().map(NewsProductStatisticsVO::getConceptInfo));
        return this.conceptInfo;
    }

    public NewsProductStatisticsItemVO getScreenConceptInfo() {
        this.screenConceptInfo = this.getNewsProductStatisticsItemVO(this.newsProductStatisticsList.stream().map(NewsProductStatisticsVO::getScreenConceptInfo));
        return this.screenConceptInfo;
    }

    public NewsProductStatisticsItemVO getPassConceptInfo() {
        this.passConceptInfo = this.getNewsProductStatisticsItemVO(this.newsProductStatisticsList.stream().map(NewsProductStatisticsVO::getPassConceptInfo));
        return this.passConceptInfo;
    }

    public NewsProductStatisticsItemVO getProposalInfo() {
        this.proposalInfo = this.getNewsProductStatisticsItemVO(this.newsProductStatisticsList.stream().map(NewsProductStatisticsVO::getProposalInfo));
        return this.proposalInfo;
    }

    public NewsProductStatisticsItemVO getPassProposalInfo() {
        this.passProposalInfo = this.getNewsProductStatisticsItemVO(this.newsProductStatisticsList.stream().map(NewsProductStatisticsVO::getPassProposalInfo));
        return this.passProposalInfo;
    }

    public BigDecimal getElementConversionRate() {
        if (this.elementInfo != null && this.conceptInfo != null) {
            this.elementConversionRate = this.elementInfo.getNewsCount() == 0 ? BigDecimal.ZERO : BigDecimal.valueOf(this.conceptInfo.getNewsCount().intValue()).divide(BigDecimal.valueOf(this.elementInfo.getNewsCount().intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            return this.elementConversionRate;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getConceptScreenRate() {
        if (this.conceptInfo != null && this.screenConceptInfo != null) {
            this.conceptScreenRate = this.conceptInfo.getNewsCount() == 0 ? BigDecimal.ZERO : BigDecimal.valueOf(this.screenConceptInfo.getNewsCount().intValue()).divide(BigDecimal.valueOf(this.conceptInfo.getNewsCount().intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            return this.conceptScreenRate;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getConceptPassRate() {
        if (this.conceptInfo != null && this.passConceptInfo != null) {
            this.conceptPassRate = this.conceptInfo.getNewsCount() == 0 ? BigDecimal.ZERO : BigDecimal.valueOf(this.passConceptInfo.getNewsCount().intValue()).divide(BigDecimal.valueOf(this.conceptInfo.getNewsCount().intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            return this.conceptPassRate;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getProposalPassRate() {
        if (this.proposalInfo != null && this.passProposalInfo != null) {
            this.proposalPassRate = this.proposalInfo.getNewsCount() == 0 ? BigDecimal.ZERO : BigDecimal.valueOf(this.passProposalInfo.getNewsCount().intValue()).divide(BigDecimal.valueOf(this.proposalInfo.getNewsCount().intValue()), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            return this.proposalPassRate;
        }
        return BigDecimal.ZERO;
    }

    public List<NewsProductStatisticsVO> getNewsProductStatisticsList() {
        return this.newsProductStatisticsList == null ? Collections.emptyList() : this.newsProductStatisticsList;
    }

    private NewsProductStatisticsItemVO getNewsProductStatisticsItemVO(Stream<NewsProductStatisticsItemVO> newsProductStatisticsItemStream) {
        List conceptList = newsProductStatisticsItemStream.collect(Collectors.toList());
        if (!conceptList.isEmpty()) {
            return new NewsProductStatisticsItemVO(conceptList.stream().mapToInt(NewsProductStatisticsItemVO::getNewsCount).sum(), conceptList.stream().mapToInt(NewsProductStatisticsItemVO::getReadCount).sum());
        }
        return null;
    }

    public NewsProductStatisticsTotalVO(List<NewsProductStatisticsVO> newsProductStatisticsList) {
        this.newsProductStatisticsList = newsProductStatisticsList;
    }

    public void setElementInfo(NewsProductStatisticsItemVO elementInfo) {
        this.elementInfo = elementInfo;
    }

    public void setConceptInfo(NewsProductStatisticsItemVO conceptInfo) {
        this.conceptInfo = conceptInfo;
    }

    public void setScreenConceptInfo(NewsProductStatisticsItemVO screenConceptInfo) {
        this.screenConceptInfo = screenConceptInfo;
    }

    public void setPassConceptInfo(NewsProductStatisticsItemVO passConceptInfo) {
        this.passConceptInfo = passConceptInfo;
    }

    public void setProposalInfo(NewsProductStatisticsItemVO proposalInfo) {
        this.proposalInfo = proposalInfo;
    }

    public void setPassProposalInfo(NewsProductStatisticsItemVO passProposalInfo) {
        this.passProposalInfo = passProposalInfo;
    }

    public void setElementConversionRate(BigDecimal elementConversionRate) {
        this.elementConversionRate = elementConversionRate;
    }

    public void setConceptScreenRate(BigDecimal conceptScreenRate) {
        this.conceptScreenRate = conceptScreenRate;
    }

    public void setConceptPassRate(BigDecimal conceptPassRate) {
        this.conceptPassRate = conceptPassRate;
    }

    public void setProposalPassRate(BigDecimal proposalPassRate) {
        this.proposalPassRate = proposalPassRate;
    }

    public void setNewsProductStatisticsList(List<NewsProductStatisticsVO> newsProductStatisticsList) {
        this.newsProductStatisticsList = newsProductStatisticsList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewsProductStatisticsTotalVO)) {
            return false;
        }
        NewsProductStatisticsTotalVO other = (NewsProductStatisticsTotalVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NewsProductStatisticsItemVO this$elementInfo = this.getElementInfo();
        NewsProductStatisticsItemVO other$elementInfo = other.getElementInfo();
        if (this$elementInfo == null ? other$elementInfo != null : !((Object)this$elementInfo).equals(other$elementInfo)) {
            return false;
        }
        NewsProductStatisticsItemVO this$conceptInfo = this.getConceptInfo();
        NewsProductStatisticsItemVO other$conceptInfo = other.getConceptInfo();
        if (this$conceptInfo == null ? other$conceptInfo != null : !((Object)this$conceptInfo).equals(other$conceptInfo)) {
            return false;
        }
        NewsProductStatisticsItemVO this$screenConceptInfo = this.getScreenConceptInfo();
        NewsProductStatisticsItemVO other$screenConceptInfo = other.getScreenConceptInfo();
        if (this$screenConceptInfo == null ? other$screenConceptInfo != null : !((Object)this$screenConceptInfo).equals(other$screenConceptInfo)) {
            return false;
        }
        NewsProductStatisticsItemVO this$passConceptInfo = this.getPassConceptInfo();
        NewsProductStatisticsItemVO other$passConceptInfo = other.getPassConceptInfo();
        if (this$passConceptInfo == null ? other$passConceptInfo != null : !((Object)this$passConceptInfo).equals(other$passConceptInfo)) {
            return false;
        }
        NewsProductStatisticsItemVO this$proposalInfo = this.getProposalInfo();
        NewsProductStatisticsItemVO other$proposalInfo = other.getProposalInfo();
        if (this$proposalInfo == null ? other$proposalInfo != null : !((Object)this$proposalInfo).equals(other$proposalInfo)) {
            return false;
        }
        NewsProductStatisticsItemVO this$passProposalInfo = this.getPassProposalInfo();
        NewsProductStatisticsItemVO other$passProposalInfo = other.getPassProposalInfo();
        if (this$passProposalInfo == null ? other$passProposalInfo != null : !((Object)this$passProposalInfo).equals(other$passProposalInfo)) {
            return false;
        }
        BigDecimal this$elementConversionRate = this.getElementConversionRate();
        BigDecimal other$elementConversionRate = other.getElementConversionRate();
        if (this$elementConversionRate == null ? other$elementConversionRate != null : !((Object)this$elementConversionRate).equals(other$elementConversionRate)) {
            return false;
        }
        BigDecimal this$conceptScreenRate = this.getConceptScreenRate();
        BigDecimal other$conceptScreenRate = other.getConceptScreenRate();
        if (this$conceptScreenRate == null ? other$conceptScreenRate != null : !((Object)this$conceptScreenRate).equals(other$conceptScreenRate)) {
            return false;
        }
        BigDecimal this$conceptPassRate = this.getConceptPassRate();
        BigDecimal other$conceptPassRate = other.getConceptPassRate();
        if (this$conceptPassRate == null ? other$conceptPassRate != null : !((Object)this$conceptPassRate).equals(other$conceptPassRate)) {
            return false;
        }
        BigDecimal this$proposalPassRate = this.getProposalPassRate();
        BigDecimal other$proposalPassRate = other.getProposalPassRate();
        if (this$proposalPassRate == null ? other$proposalPassRate != null : !((Object)this$proposalPassRate).equals(other$proposalPassRate)) {
            return false;
        }
        List<NewsProductStatisticsVO> this$newsProductStatisticsList = this.getNewsProductStatisticsList();
        List<NewsProductStatisticsVO> other$newsProductStatisticsList = other.getNewsProductStatisticsList();
        return !(this$newsProductStatisticsList == null ? other$newsProductStatisticsList != null : !((Object)this$newsProductStatisticsList).equals(other$newsProductStatisticsList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NewsProductStatisticsTotalVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NewsProductStatisticsItemVO $elementInfo = this.getElementInfo();
        result = result * 59 + ($elementInfo == null ? 43 : ((Object)$elementInfo).hashCode());
        NewsProductStatisticsItemVO $conceptInfo = this.getConceptInfo();
        result = result * 59 + ($conceptInfo == null ? 43 : ((Object)$conceptInfo).hashCode());
        NewsProductStatisticsItemVO $screenConceptInfo = this.getScreenConceptInfo();
        result = result * 59 + ($screenConceptInfo == null ? 43 : ((Object)$screenConceptInfo).hashCode());
        NewsProductStatisticsItemVO $passConceptInfo = this.getPassConceptInfo();
        result = result * 59 + ($passConceptInfo == null ? 43 : ((Object)$passConceptInfo).hashCode());
        NewsProductStatisticsItemVO $proposalInfo = this.getProposalInfo();
        result = result * 59 + ($proposalInfo == null ? 43 : ((Object)$proposalInfo).hashCode());
        NewsProductStatisticsItemVO $passProposalInfo = this.getPassProposalInfo();
        result = result * 59 + ($passProposalInfo == null ? 43 : ((Object)$passProposalInfo).hashCode());
        BigDecimal $elementConversionRate = this.getElementConversionRate();
        result = result * 59 + ($elementConversionRate == null ? 43 : ((Object)$elementConversionRate).hashCode());
        BigDecimal $conceptScreenRate = this.getConceptScreenRate();
        result = result * 59 + ($conceptScreenRate == null ? 43 : ((Object)$conceptScreenRate).hashCode());
        BigDecimal $conceptPassRate = this.getConceptPassRate();
        result = result * 59 + ($conceptPassRate == null ? 43 : ((Object)$conceptPassRate).hashCode());
        BigDecimal $proposalPassRate = this.getProposalPassRate();
        result = result * 59 + ($proposalPassRate == null ? 43 : ((Object)$proposalPassRate).hashCode());
        List<NewsProductStatisticsVO> $newsProductStatisticsList = this.getNewsProductStatisticsList();
        result = result * 59 + ($newsProductStatisticsList == null ? 43 : ((Object)$newsProductStatisticsList).hashCode());
        return result;
    }

    public String toString() {
        return "NewsProductStatisticsTotalVO(elementInfo=" + this.getElementInfo() + ", conceptInfo=" + this.getConceptInfo() + ", screenConceptInfo=" + this.getScreenConceptInfo() + ", passConceptInfo=" + this.getPassConceptInfo() + ", proposalInfo=" + this.getProposalInfo() + ", passProposalInfo=" + this.getPassProposalInfo() + ", elementConversionRate=" + this.getElementConversionRate() + ", conceptScreenRate=" + this.getConceptScreenRate() + ", conceptPassRate=" + this.getConceptPassRate() + ", proposalPassRate=" + this.getProposalPassRate() + ", newsProductStatisticsList=" + this.getNewsProductStatisticsList() + ")";
    }
}

