/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.law.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;

public final class BeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);

    private BeanUtils() {
    }

    public static void copyProperties(Object src, Object target) {
        org.springframework.beans.BeanUtils.copyProperties((Object)src, (Object)target);
    }

    public static void copyPropertiesWithoutId(Object src, Object target) {
        org.springframework.beans.BeanUtils.copyProperties((Object)src, (Object)target, (String[])new String[]{"id"});
    }

    public static void copyPropertiesIgnoreNull(Object src, Object target) {
        if (null != target && null != src) {
            org.springframework.beans.BeanUtils.copyProperties((Object)src, (Object)target, (String[])BeanUtils.getNullPropertyNames(src));
        } else {
            logger.warn("Target object or Source object must not be null.");
        }
    }

    public static void copyPropertiesWithId(Object src, Object target) {
        if (null != target && null != src) {
            BeanUtils.copyPropertiesIgnoreNull(src, target);
            Class<?> clazzSrc = src.getClass();
            Class<?> clazzTarget = target.getClass();
            try {
                Method getFiled = clazzSrc.getMethod("getId", new Class[0]);
                Method setFiled = clazzTarget.getMethod("setId", Long.class);
                Object value = getFiled.invoke(src, new Object[0]);
                setFiled.invoke(target, value);
            }
            catch (Exception var7) {
                logger.info("Java\u53cd\u5c04\u8c03\u7528\u5931\u8d25,\u8c03\u7528\u7c7b%s\u4e2d\u6ca1\u6709 getId\u6216 setId\u65b9\u6cd5");
            }
        } else {
            logger.warn("Target object or Source object must not be null.");
        }
    }

    private static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        PropertyDescriptor[] var4 = pds;
        int var5 = pds.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            PropertyDescriptor pd = var4[var6];
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }
}

