/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Msg;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private Reader in2;
    private char[] buf;
    private int marklimit = -1;
    private int count;
    private int markpos = -1;
    private int pos;

    public BufferedReader(Reader in) {
        super(in);
        this.in2 = in;
        this.buf = new char[8192];
    }

    public BufferedReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException(Msg.getString("K0058"));
        }
        this.in2 = in;
        this.buf = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.in2.close();
                this.buf = null;
            }
        }
    }

    private int fillbuf() throws IOException {
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int result = this.in2.read(this.buf, 0, this.buf.length);
            if (result > 0) {
                this.markpos = -1;
                this.pos = 0;
                this.count = result == -1 ? 0 : result;
            }
            return result;
        }
        if (this.markpos == 0 && this.marklimit > this.buf.length) {
            int newLength = this.buf.length * 2;
            if (newLength > this.marklimit) {
                newLength = this.marklimit;
            }
            char[] newbuf = new char[newLength];
            System.arraycopy(this.buf, 0, newbuf, 0, this.buf.length);
            this.buf = newbuf;
        } else if (this.markpos > 0) {
            System.arraycopy(this.buf, this.markpos, this.buf, 0, this.buf.length - this.markpos);
        }
        this.pos -= this.markpos;
        this.markpos = 0;
        this.count = 0;
        int charsread = this.in2.read(this.buf, this.pos, this.buf.length - this.pos);
        this.count = charsread == -1 ? this.pos : this.pos + charsread;
        return charsread;
    }

    private boolean isOpen() {
        return this.buf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void mark(int readlimit) throws IOException {
        if (readlimit >= 0) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isOpen()) {
                    throw new IOException(Msg.getString("K005b"));
                }
                this.marklimit = readlimit;
                this.markpos = this.pos;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.pos < this.count || this.fillbuf() != -1) {
                    return this.buf[this.pos++];
                }
                return -1;
            }
            throw new IOException(Msg.getString("K005b"));
        }
    }

    @Override
    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int required;
            if (!this.isOpen()) {
                throw new IOException(Msg.getString("K005b"));
            }
            if (offset < 0 || offset > buffer.length - length || length < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (length == 0) {
                return 0;
            }
            if (this.pos < this.count) {
                int copylength = this.count - this.pos >= length ? length : this.count - this.pos;
                System.arraycopy(this.buf, this.pos, buffer, offset, copylength);
                this.pos += copylength;
                if (copylength == length || !this.in2.ready()) {
                    return copylength;
                }
                offset += copylength;
                required = length - copylength;
            } else {
                required = length;
            }
            while (true) {
                int read;
                if (this.markpos == -1 && required >= this.buf.length) {
                    read = this.in2.read(buffer, offset, required);
                    if (read == -1) {
                        return required == length ? -1 : length - required;
                    }
                } else {
                    if (this.fillbuf() == -1) {
                        return required == length ? -1 : length - required;
                    }
                    read = this.count - this.pos >= required ? required : this.count - this.pos;
                    System.arraycopy(this.buf, this.pos, buffer, offset, read);
                    this.pos += read;
                }
                if ((required -= read) == 0) {
                    return length;
                }
                if (!this.in2.ready()) {
                    return length - required;
                }
                offset += read;
            }
        }
    }

    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.pos >= this.count && this.fillbuf() == -1) {
                    return null;
                }
                for (int charPos = this.pos; charPos < this.count; ++charPos) {
                    char ch = this.buf[charPos];
                    if (ch > '\r') continue;
                    if (ch == '\n') {
                        String res = new String(this.buf, this.pos, charPos - this.pos);
                        this.pos = charPos + 1;
                        return res;
                    }
                    if (ch != '\r') continue;
                    String res = new String(this.buf, this.pos, charPos - this.pos);
                    this.pos = charPos + 1;
                    if ((this.pos < this.count || this.fillbuf() != -1) && this.buf[this.pos] == '\n') {
                        ++this.pos;
                    }
                    return res;
                }
                int eol = 0;
                StringBuilder result = new StringBuilder(80);
                result.append(this.buf, this.pos, this.count - this.pos);
                this.pos = this.count;
                while (true) {
                    if (this.pos >= this.count) {
                        if (eol == 10) {
                            return result.toString();
                        }
                        if (this.fillbuf() == -1) {
                            return result.length() > 0 || eol != 0 ? result.toString() : null;
                        }
                    }
                    for (int charPos = this.pos; charPos < this.count; ++charPos) {
                        if (eol == 0) {
                            if (this.buf[charPos] != '\n' && this.buf[charPos] != '\r') continue;
                            eol = this.buf[charPos];
                            continue;
                        }
                        if (eol == 13 && this.buf[charPos] == '\n') {
                            if (charPos > this.pos) {
                                result.append(this.buf, this.pos, charPos - this.pos - 1);
                            }
                            this.pos = charPos + 1;
                            return result.toString();
                        }
                        if (eol == 0) continue;
                        if (charPos > this.pos) {
                            result.append(this.buf, this.pos, charPos - this.pos - 1);
                        }
                        this.pos = charPos;
                        return result.toString();
                    }
                    if (eol == 0) {
                        result.append(this.buf, this.pos, this.count - this.pos);
                    } else {
                        result.append(this.buf, this.pos, this.count - this.pos - 1);
                    }
                    this.pos = this.count;
                }
            }
            throw new IOException(Msg.getString("K005b"));
        }
    }

    @Override
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                return this.count - this.pos > 0 || this.in2.ready();
            }
            throw new IOException(Msg.getString("K005b"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.markpos == -1) {
                    throw new IOException(Msg.getString("K005c"));
                }
            } else {
                throw new IOException(Msg.getString("K005b"));
            }
            this.pos = this.markpos;
        }
    }

    @Override
    @Override
    public long skip(long amount) throws IOException {
        if (amount >= 0L) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isOpen()) {
                    if (amount < 1L) {
                        return 0L;
                    }
                    if ((long)(this.count - this.pos) >= amount) {
                        this.pos = (int)((long)this.pos + amount);
                        return amount;
                    }
                    this.pos = this.count;
                    for (long read = (long)(this.count - this.pos); read < amount; read += (long)(this.count - this.pos)) {
                        if (this.fillbuf() == -1) {
                            return read;
                        }
                        if ((long)(this.count - this.pos) >= amount - read) {
                            this.pos = (int)((long)this.pos + (amount - read));
                            return amount;
                        }
                        this.pos = this.count;
                    }
                    return amount;
                }
                throw new IOException(Msg.getString("K005b"));
            }
        }
        throw new IllegalArgumentException();
    }
}

