/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class PrintStream
extends OutputStream {
    private boolean errorState = false;
    private OutputStream out;

    public PrintStream(OutputStream theOut) {
        this.out = theOut;
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public boolean checkError() {
        this.flush();
        return this.errorState;
    }

    protected void setError() {
        this.errorState = true;
    }

    @Override
    public void write(int b) {
        try {
            this.out.write(b);
        }
        catch (IOException e) {
            this.setError();
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            this.out.write(buf, off, len);
        }
        catch (IOException e) {
            this.setError();
        }
    }

    @Override
    public void write(String str) {
        try {
            this.out.write(str);
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(char[] buf) {
        String s = new String(buf);
        this.print(s);
    }

    public void print(String s) {
        try {
            this.out.write(s);
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void print(Object obj) {
        if (obj == null) {
            this.print("null");
        } else {
            this.print(obj.toString());
        }
    }

    public void println() {
        this.print("\n");
    }

    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    public void println(char x) {
        this.print(x);
        this.println();
    }

    public void println(int x) {
        this.print(x);
        this.println();
    }

    public void println(long x) {
        this.print(x);
        this.println();
    }

    public void println(float x) {
        this.print(x);
        this.println();
    }

    public void println(double x) {
        this.print(x);
        this.println();
    }

    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    public void println(String x) {
        this.print(x);
        this.println();
    }

    public void println(Object x) {
        this.print(x);
        this.println();
    }
}

