/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;

public abstract class Reader
implements Readable,
Closeable {
    protected Object lock;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    @Override
    public abstract void close() throws IOException;

    public void mark(int readLimit) throws IOException {
        throw new IOException();
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] charArray = new char[1];
            if (this.read(charArray, 0, 1) != -1) {
                return charArray[0];
            }
            return -1;
        }
    }

    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public boolean ready() throws IOException {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long count) throws IOException {
        if (count >= 0L) {
            Object object = this.lock;
            synchronized (object) {
                long skipped;
                int read;
                int toRead = count < 512L ? (int)count : 512;
                char[] charsSkipped = new char[toRead];
                for (skipped = 0L; skipped < count; skipped += (long)read) {
                    read = this.read(charsSkipped, 0, toRead);
                    if (read == -1) {
                        return skipped;
                    }
                    if (read >= toRead) continue;
                    return skipped;
                }
                return skipped;
            }
        }
        throw new IllegalArgumentException();
    }
}

