/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Msg;
import java.io.Reader;

public class StringReader
extends Reader {
    private String str;
    private int markpos = -1;
    private int pos;
    private int count;

    public StringReader(String str) {
        super(str);
        this.str = str;
        this.count = str.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.str = null;
            }
        }
    }

    private boolean isOpen() {
        return this.str != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void mark(int readLimit) throws IOException {
        if (readLimit >= 0) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isOpen()) {
                    throw new IOException(Msg.getString("K0083"));
                }
                this.markpos = this.pos;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.pos != this.count) {
                    return this.str.charAt(this.pos++);
                }
                return -1;
            }
            throw new IOException(Msg.getString("K0083"));
        }
    }

    @Override
    @Override
    public int read(char[] buf, int offset, int len) throws IOException {
        if (0 <= offset && offset <= buf.length && 0 <= len && len <= buf.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isOpen()) {
                    if (this.pos == this.count) {
                        return -1;
                    }
                    int end = this.pos + len > this.count ? this.count : this.pos + len;
                    this.str.getChars(this.pos, end, buf, offset);
                    int read = end - this.pos;
                    this.pos = end;
                    return read;
                }
                throw new IOException(Msg.getString("K0083"));
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                return true;
            }
            throw new IOException(Msg.getString("K0083"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException(Msg.getString("K0083"));
            }
            this.pos = this.markpos != -1 ? this.markpos : 0;
        }
    }

    @Override
    @Override
    public long skip(long ns) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (ns <= 0L) {
                    return 0L;
                }
                long skipped = 0L;
                if (ns < (long)(this.count - this.pos)) {
                    this.pos += (int)ns;
                    skipped = ns;
                } else {
                    skipped = this.count - this.pos;
                    this.pos = this.count;
                }
                return skipped;
            }
            throw new IOException(Msg.getString("K0083"));
        }
    }
}

