/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.dragome.commons.javascript.ScriptHelper;

public final class Character {
    public static final Class<Character> TYPE = Class.getType("char");
    private char value;

    public Character(char c) {
        this.value = c;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Character)) {
            return false;
        }
        return ((Character)obj).value == this.value;
    }

    public static boolean isDigit(char ch) {
        return String.valueOf(ch).matches("[0-9]");
    }

    public static boolean isLetter(char ch) {
        return String.valueOf(ch).matches("[a-zA-Z]");
    }

    public static Character valueOf(char value) {
        return new Character(value);
    }

    public char charValue() {
        return this.value;
    }

    public String toString() {
        ScriptHelper.put((String)"c", (double)this.value, (Object)this);
        return (String)ScriptHelper.eval((String)"String.fromCharCode(c)", (Object)this);
    }

    public static char toUpperCase(char c) {
        return ("" + c).toUpperCase().charAt(0);
    }

    public static char toLowerCase(char c) {
        return ("" + c).toLowerCase().charAt(0);
    }

    public static boolean isISOControl(char ch) {
        return Character.isISOControl((int)ch);
    }

    public static boolean isISOControl(int codePoint) {
        return codePoint >= 0 && codePoint <= 31 || codePoint >= 127 && codePoint <= 159;
    }

    public static boolean isUpperCase(char c) {
        return 'A' <= c && c <= 'Z';
    }

    public static boolean isLowerCase(char c) {
        return 'a' <= c && c <= 'z';
    }

    public static boolean isSpaceChar(char c) {
        return Character.isSpace(c);
    }

    public static boolean isWhitespace(char ch) {
        return Character.isSpace(ch);
    }

    public static boolean isSpace(char c) {
        switch (c) {
            case ' ': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\t': {
                return true;
            }
            case '\f': {
                return true;
            }
            case '\r': {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetterOrDigit(char c) {
        ScriptHelper.put((String)"c", (double)c, null);
        return ScriptHelper.evalBoolean((String)"null != String.fromCharCode(c).match(/[A-Z\\d]/i)", null);
    }
}

