/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.dragome.commons.compiler.annotations.CompilerType;
import com.dragome.commons.compiler.annotations.DragomeCompilerSettings;
import com.dragome.commons.javascript.JSObject;
import com.dragome.commons.javascript.ScriptHelper;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

@DragomeCompilerSettings(value=CompilerType.Standard)
public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static JSObject<Class<?>> classesByName = new JSObject();
    private static JSObject<Method> foundMethods = new JSObject();
    protected Object nativeClass;
    protected Method[] methods;
    protected List<Method> declaredMethods;
    protected Method[] declaredMethodsInDepth;
    protected Class<?>[] interfacesCache;

    public String getSimpleName() {
        String simpleName = this.getName();
        return simpleName.substring(simpleName.lastIndexOf(46) + 1);
    }

    private Class(Object theNativeClass) {
        this.nativeClass = theNativeClass;
    }

    public String toString() {
        return "class " + this.getName();
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class clazz = (Class)classesByName.get(className);
        if (clazz == null) {
            String jsClassName;
            if (className.startsWith("[") && className.endsWith(";")) {
                className = Array.class.getName();
            }
            if ("boolean".equals(jsClassName = className.replaceAll("\\.", "_"))) {
                jsClassName = "java_lang_Boolean";
            } else if ("int".equals(jsClassName)) {
                jsClassName = "java_lang_Integer";
            } else if ("void".equals(jsClassName)) {
                jsClassName = "java_lang_Void";
            } else if ("long".equals(jsClassName)) {
                jsClassName = "java_lang_Long";
            } else if ("byte".equals(jsClassName)) {
                jsClassName = "java_lang_Byte";
            } else if ("char".equals(jsClassName)) {
                jsClassName = "java_lang_Character";
            } else if ("float".equals(jsClassName)) {
                jsClassName = "java_lang_Float";
            } else if ("double".equals(jsClassName)) {
                jsClassName = "java_lang_Double";
            } else if ("short".equals(jsClassName)) {
                jsClassName = "java_lang_Short";
            }
            jsClassName = jsClassName.replace("_ARRAYTYPE", "");
            ScriptHelper.put((String)"jsClassName", (Object)jsClassName, null);
            Object nativeClass = null;
            ScriptHelper.eval((String)"try{var result= eval(jsClassName)}catch(e){}", null);
            nativeClass = ScriptHelper.eval((String)"result", null);
            if (nativeClass == null) {
                throw new ClassNotFoundException(jsClassName);
            }
            clazz = new Class(nativeClass);
            ScriptHelper.put((String)"clazz", clazz, null);
            ScriptHelper.put((String)"className", (Object)className, null);
            ScriptHelper.eval((String)"clazz.realName=className", null);
            classesByName.put(className, clazz);
        }
        return clazz;
    }

    public Class<?> getComponentType() {
        throw new UnsupportedOperationException();
    }

    public T newInstance() throws InstantiationException, IllegalAccessException {
        ScriptHelper.eval((String)"var o = new this.$$$nativeClass", (Object)this);
        ScriptHelper.eval((String)"o.$$init_$void()", (Object)this);
        return (T)ScriptHelper.eval((String)"o", (Object)this);
    }

    public boolean isInstance(Object obj) {
        Class<T> cls = obj.getClass();
        while (!cls.getName().equals(this.getName())) {
            if (cls.getName().equals("java.lang.Object")) {
                return false;
            }
            cls = cls.getSuperclass();
        }
        return true;
    }

    public boolean isAssignableFrom(Class<?> otherClass) {
        Class<?>[] interfaces = this.getInterfaces();
        if (otherClass == null) {
            throw new NullPointerException();
        }
        if (otherClass.isInterface() && Object.class.equals(this)) {
            return true;
        }
        ScriptHelper.put((String)"otherClass", otherClass, (Object)this);
        return ScriptHelper.evalBoolean((String)"dragomeJs.isInstanceof(otherClass.$$$nativeClass, this.$$$nativeClass)", (Object)this);
    }

    public boolean isInterface() {
        return ScriptHelper.evalBoolean((String)"this.$$$nativeClass.$$type == \"Interface\"", (Object)this);
    }

    public boolean isArray() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public String getName() {
        String result = this.isInterface() ? (String)ScriptHelper.eval((String)"this.$$$nativeClass.name", (Object)this) : (String)ScriptHelper.eval((String)"this.$$$nativeClass.classname", (Object)this);
        return result != null ? result.replace("_", ".") : "java.lang.Object";
    }

    public Class<? super T> getSuperclass() {
        if (ScriptHelper.evalBoolean((String)"this.$$$nativeClass.classname == 'java_lang_Object' ", (Object)this)) {
            return null;
        }
        Boolean eval = ScriptHelper.evalBoolean((String)"this.$$$nativeClass.superclass != undefined", (Object)this);
        return eval != false ? new Class<T>(ScriptHelper.eval((String)"this.$$$nativeClass.superclass", (Object)this)) : null;
    }

    public Method[] getDeclaredMethods() {
        if (this.declaredMethods == null) {
            this.declaredMethods = new ArrayList<Method>();
            String[] signatures = new String[]{};
            ScriptHelper.put((String)"signatures", (Object)signatures, (Object)this);
            ScriptHelper.eval((String)"for (var e in this.$$$nativeClass.$$members) { if (typeof this.$$$nativeClass.$$members[e]  === 'function' && e.startsWith('$')) signatures.push(e); }", (Object)this);
            ScriptHelper.eval((String)"for (var e in this.$$$nativeClass.prototype) { if (typeof this.$$$nativeClass.prototype[e]  === 'function' && e.startsWith('$')) signatures.push(e); }", (Object)this);
            this.addMethods(signatures, 1);
            signatures = new String[]{};
            ScriptHelper.eval((String)"for (var e in this.$$$nativeClass) { if (typeof this.$$$nativeClass[e]  === 'function' && e.startsWith('$')) signatures.push(e); }", (Object)this);
            this.addMethods(signatures, 9);
        }
        return this.declaredMethods.toArray(new Method[0]);
    }

    private void addMethods(String[] signatures, int modifier) {
        int j = 0;
        for (int i = 0; i < signatures.length; ++i) {
            String signature = signatures[i];
            if (signature.startsWith("$$init_") || signature.startsWith("$$clinit_")) continue;
            this.declaredMethods.add(new Method(this, signatures[i], modifier));
            ++j;
        }
    }

    public Method[] getDeclaredMethodsInDepth() {
        if (this.declaredMethodsInDepth == null) {
            this.declaredMethodsInDepth = this.getDeclaredMethods();
            Class<T> superclass = this.getSuperclass();
            int j = this.declaredMethodsInDepth.length;
            if (superclass != null) {
                for (Method method : superclass.getDeclaredMethodsInDepth()) {
                    this.declaredMethodsInDepth[j++] = method;
                }
            }
        }
        return this.declaredMethodsInDepth;
    }

    public Method[] getMethods() {
        if (this.methods == null) {
            this.methods = new Method[0];
            int j = 0;
            for (Class<?> interfaze : this.getInterfaces()) {
                for (Method method : interfaze.getMethods()) {
                    this.methods[j++] = method;
                }
            }
            Class<T> superclass = this.getSuperclass();
            if (superclass != null) {
                for (Method method : superclass.getMethods()) {
                    this.methods[j++] = method;
                }
            }
            for (Method method : this.getDeclaredMethods()) {
                this.methods[j++] = method;
            }
        }
        return this.methods;
    }

    public Class<?>[] getInterfaces() {
        if (this.interfacesCache == null) {
            ArrayList interfacesCollection = new ArrayList();
            ScriptHelper.put((String)"interfacesCollection", interfacesCollection, (Object)this);
            if (this.isInterface()) {
                ScriptHelper.eval((String)"var interfacesList= this.$$$nativeClass.$$extends", (Object)this);
            } else {
                ScriptHelper.eval((String)"var interfacesList= this.$$$nativeClass.$$implements", (Object)this);
            }
            ScriptHelper.eval((String)"for (var e in interfacesList) {", (Object)this);
            if (ScriptHelper.evalBoolean((String)"interfacesList[e].$$type != 'Class'", (Object)this)) {
                String className = (String)ScriptHelper.eval((String)"interfacesList[e].$$$nativeClass ? interfacesList[e].$$$nativeClass.name : interfacesList[e].name", (Object)this);
                try {
                    interfacesCollection.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ScriptHelper.eval((String)"}", (Object)this);
            this.interfacesCache = new Class[interfacesCollection.size()];
            int i = 0;
            for (Class clazz : interfacesCollection) {
                this.interfacesCache[i++] = clazz;
            }
        }
        return this.interfacesCache;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] annotations = new Annotation[]{};
        Object[] maps = (Object[])ScriptHelper.eval((String)"this.$$$nativeClass.annotations", (Object)this);
        if (maps == null) {
            return annotations;
        }
        int i = 0;
        for (Object map : maps) {
            AnnotationInvocationHandler handler = new AnnotationInvocationHandler(new JSObject(map));
            Annotation annotation = (Annotation)Proxy.newProxyInstance(null, new Class[]{null}, handler);
            annotations[i++] = annotation;
        }
        return annotations;
    }

    public boolean desiredAssertionStatus() {
        return false;
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        String argumentTypesToString = Class.argumentTypesToString(parameterTypes);
        String key = name + argumentTypesToString;
        Method foundMethod = (Method)foundMethods.get(key);
        if (foundMethod == null) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = this.getMethods()) {
                if (!method.getName().equals(name) || !Class.arrayContentsEq(parameterTypes, method.getParameterTypes()) || foundMethod != null && !foundMethod.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                foundMethod = method;
                foundMethods.put(key, (Object)foundMethod);
            }
        }
        if (foundMethod == null) {
            throw new NoSuchMethodException(this.getName() + "." + key);
        }
        return foundMethod;
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return new Constructor(this, new Class[0], new Class[0], 0);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return null;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return false;
    }

    @Override
    public TypeVariable<?>[] getTypeParameters() {
        return null;
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        if (parameterTypes == null || parameterTypes.length > 0) {
            throw new NoSuchMethodException();
        }
        return new Constructor(this, parameterTypes, null, 1);
    }

    public Field[] getFields() throws SecurityException {
        return new Field[0];
    }

    public Field[] getDeclaredFields() throws SecurityException {
        return new Field[0];
    }

    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        return null;
    }

    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        return null;
    }

    public String getResourceAsStream(String resourcePath) {
        return null;
    }

    public boolean isPrimitive() {
        String realName = (String)ScriptHelper.eval((String)"this.realName", null);
        return !realName.contains("_") && !realName.contains(".");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        ScriptHelper.put((String)"obj", (Object)obj, (Object)this);
        boolean result = ScriptHelper.evalBoolean((String)"obj.$$$nativeClass == this.$$$nativeClass", (Object)this);
        return result;
    }

    public Package getPackage() {
        String name = this.getName();
        String packageName = name.substring(0, name.indexOf(this.getSimpleName()) - 1);
        return new Package(packageName);
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (clazz.isAssignableFrom(this)) {
            return this;
        }
        throw new ClassCastException(this.toString());
    }

    public int getModifiers() {
        return 1;
    }

    public String getCanonicalName() {
        return this.getName();
    }

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getMethod(name, parameterTypes);
    }

    public static <T> Class<T> getType(String typeName) {
        try {
            return Class.forName(typeName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ProtectionDomain getProtectionDomain() {
        return null;
    }

    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(name);
    }

    private static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i].equals(a2[i])) continue;
            return false;
        }
        return true;
    }

    private class AnnotationInvocationHandler
    implements InvocationHandler {
        private JSObject<?> object;

        AnnotationInvocationHandler(JSObject<?> theObject) {
            this.object = theObject;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String name = method.getName();
            if (name.equals("toString")) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("@" + this.object.get("$signature"));
                return buffer.toString();
            }
            return this.object.get(method.getName());
        }
    }
}

