/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.dragome.commons.javascript.ScriptHelper;
import javascript.Utils;

public final class Double
extends Number
implements Comparable<Double> {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    private static final double POWER_512 = 1.3407807929942597E154;
    private static final double POWER_MINUS_512 = 7.458340731200207E-155;
    private static final double POWER_256 = 1.157920892373162E77;
    private static final double POWER_MINUS_256 = 8.636168555094445E-78;
    private static final double POWER_128 = 3.402823669209385E38;
    private static final double POWER_MINUS_128 = 2.938735877055719E-39;
    private static final double POWER_64 = 1.8446744073709552E19;
    private static final double POWER_MINUS_64 = 5.421010862427522E-20;
    private static final double POWER_52 = 4.503599627370496E15;
    private static final double POWER_MINUS_52 = 2.220446049250313E-16;
    private static final double POWER_32 = 4.294967296E9;
    private static final double POWER_MINUS_32 = 2.3283064365386963E-10;
    private static final double POWER_31 = 2.147483648E9;
    private static final double POWER_20 = 1048576.0;
    private static final double POWER_MINUS_20 = 9.5367431640625E-7;
    private static final double POWER_16 = 65536.0;
    private static final double POWER_MINUS_16 = 1.52587890625E-5;
    private static final double POWER_8 = 256.0;
    private static final double POWER_MINUS_8 = 0.00390625;
    private static final double POWER_4 = 16.0;
    private static final double POWER_MINUS_4 = 0.0625;
    private static final double POWER_2 = 4.0;
    private static final double POWER_MINUS_2 = 0.25;
    private static final double POWER_1 = 2.0;
    private static final double POWER_MINUS_1 = 0.5;
    private static final double POWER_MINUS_1022 = 2.2250738585072014E-308;
    private static final double[] powers = new double[]{1.3407807929942597E154, 1.157920892373162E77, 3.402823669209385E38, 1.8446744073709552E19, 4.294967296E9, 65536.0, 256.0, 16.0, 4.0, 2.0};
    private static final double[] invPowers = new double[]{7.458340731200207E-155, 8.636168555094445E-78, 2.938735877055719E-39, 5.421010862427522E-20, 2.3283064365386963E-10, 1.52587890625E-5, 0.00390625, 0.0625, 0.25, 0.5};
    public static final double NaN = 0.0 / 0.0;
    public static final Class<Double> TYPE = Class.getType("double");
    private double value;

    public Double(double d) {
        this.value = d;
    }

    public Double(String s) {
        this.value = Double.parseDouble(s);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Double)) {
            return false;
        }
        return ((Double)obj).value == this.value;
    }

    @Override
    public int compareTo(Double o) {
        return Utils.cmp(this.value, o, 0);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public static boolean isNaN(double v) {
        ScriptHelper.put((String)"value", (double)v, null);
        return ScriptHelper.evalBoolean((String)"isNaN(value)", null);
    }

    public static double parseDouble(String s) throws NumberFormatException {
        if (s == null) {
            throw new NullPointerException();
        }
        if ((s = s.trim()).matches("(\\+|\\-)?NaN")) {
            return Double.NaN;
        }
        ScriptHelper.put((String)"s", (Object)s, null);
        double d = ScriptHelper.evalDouble((String)"parseFloat(s)", null);
        if (Double.isNaN(d)) {
            throw new NumberFormatException("Not a parsable double: " + s);
        }
        return d;
    }

    public static Double valueOf(double value) {
        return new Double(value);
    }

    public static Double valueOf(String s) throws NumberFormatException {
        return new Double(Double.parseDouble(s));
    }

    public String toString() {
        ScriptHelper.put((String)"value", (double)this.value, (Object)this);
        return (String)ScriptHelper.eval((String)"String(value)", (Object)this);
    }

    public static double longBitsToDouble(long bits) {
        double d;
        boolean negative;
        block11: {
            int exp;
            block10: {
                long ihi = bits >> 32;
                long ilo = bits & 0xFFFFFFFFL;
                if (ihi < 0L) {
                    ihi += 0x100000000L;
                }
                if (ilo < 0L) {
                    ilo += 0x100000000L;
                }
                negative = (ihi & Integer.MIN_VALUE) != 0L;
                exp = (int)(ihi >> 20 & 0x7FFL);
                ihi &= 0xFFFFFL;
                if (exp == 0) {
                    double d2 = (double)ihi * 9.5367431640625E-7 + (double)ilo * 2.220446049250313E-16;
                    return negative ? (d2 == 0.0 ? -0.0 : -d2) : (d2 *= Double.MIN_NORMAL);
                }
                if (exp == 2047) {
                    if (ihi == 0L && ilo == 0L) {
                        return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    return Double.NaN;
                }
                d = 1.0 + (double)ihi * 9.5367431640625E-7 + (double)ilo * 2.220446049250313E-16;
                if ((exp -= 1023) <= 0) break block10;
                int bit = 512;
                int i = 0;
                while (i < 10) {
                    if (exp >= bit) {
                        d *= powers[i];
                        exp -= bit;
                    }
                    ++i;
                    bit >>= 1;
                }
                break block11;
            }
            if (exp >= 0) break block11;
            while (exp < 0) {
                int bit = 512;
                int i = 0;
                while (i < 10) {
                    if (exp <= -bit) {
                        d *= invPowers[i];
                        exp += bit;
                    }
                    ++i;
                    bit >>= 1;
                }
            }
        }
        return negative ? -d : d;
    }

    public static long doubleToLongBits(double v) {
        if (Double.isNaN(v)) {
            return 9221120237041090560L;
        }
        long sign = v < 0.0 ? Long.MIN_VALUE : 0L;
        long exponent = 0L;
        double absV = Math.abs(v);
        if (Double.isInfinite(v)) {
            exponent = 0x7FF0000000000000L;
        } else if (absV == 0.0) {
            exponent = 0L;
        } else {
            int guess = (int)Math.floor(Math.log(absV) / Math.log(2.0));
            guess = Math.max(-1023, Math.min(guess, 1023));
            double exp = Math.pow(2.0, guess);
            absV /= exp;
            while (absV > 2.0) {
                ++guess;
                absV /= 2.0;
            }
            while (absV < 1.0 && guess > 1024) {
                --guess;
                absV *= 2.0;
            }
            exponent = (long)guess + 1023L << 52;
        }
        if (exponent <= 0L) {
            absV /= 2.0;
        }
        long mantissa = (long)(absV % 1.0 * Math.pow(2.0, 52.0));
        return sign | exponent | mantissa & 0xFFFFFFFFFFFFFL;
    }

    public static boolean isInfinite(double v) {
        return v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }

    public static String toString(double d) {
        return d + "";
    }

    public static int compare(double d1, double d2) {
        long anotherBits;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(d1);
        return thisBits == (anotherBits = Double.doubleToLongBits(d2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    public static int hashCode(double value) {
        return Double.hashCode((long)value);
    }
}

