/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.dragome.commons.javascript.ScriptHelper;

public class Integer
extends Number
implements Comparable<Integer> {
    public static int MAX_VALUE = Integer.MAX_VALUE;
    public static int MIN_VALUE = Integer.MIN_VALUE;
    public static final Class<Integer> TYPE = Class.getType("int");
    private int value;

    public Integer(int newValue) {
        this.value = newValue;
    }

    public Integer(String aValue) {
        this.value = Integer.parseInt(aValue);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Integer)) {
            return false;
        }
        return ((Integer)obj).value == this.value;
    }

    public static String toString(int i, int radix) {
        ScriptHelper.put((String)"i", (double)i, null);
        ScriptHelper.put((String)"radix", (double)radix, null);
        return (String)ScriptHelper.eval((String)"new Number(i).toString(radix)", null);
    }

    public static String toHexString(int i) {
        return Integer.toString(i, 16);
    }

    public static String toOctalString(int i) {
        return Integer.toString(i, 8);
    }

    public static String toBinaryString(int i) {
        return Integer.toString(i, 2);
    }

    public static String toString(int i) {
        return Integer.toString(i, 10);
    }

    public static int parseInt(String s, int radix) {
        if (s == null) {
            throw new NullPointerException();
        }
        s = s.trim();
        ScriptHelper.put((String)"s", (Object)s, null);
        ScriptHelper.put((String)"radix", (double)radix, null);
        int i = ScriptHelper.evalInt((String)"parseInt(s, radix)", null);
        ScriptHelper.put((String)"i", (double)i, null);
        ScriptHelper.put((String)"radix", (double)radix, null);
        if (!s.equals(ScriptHelper.eval((String)"new Number(i).toString(radix)", null))) {
            throw new NumberFormatException("Invalid integer: " + s);
        }
        return i;
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s, 10);
    }

    public static Integer valueOf(int value) {
        return new Integer(value);
    }

    public static Integer valueOf(String s, int radix) {
        return new Integer(Integer.parseInt(s, radix));
    }

    public static Integer valueOf(String s) {
        return new Integer(Integer.parseInt(s));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value, 10);
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(Integer object) {
        return this.value > object.value ? 1 : (this.value < object.value ? -1 : 0);
    }

    public static int hashCode(int value) {
        return value ^ value >>> 32;
    }
}

