/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private static final long serialVersionUID = 6992337162326171013L;

    public StackTraceElement(String declaringClass, String methodName, String fileName, int lineNumber) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        return this.getClassName() + "." + this.methodName + (this.isNativeMethod() ? "(Native Method)" : (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)")));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement e = (StackTraceElement)obj;
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

